# 🎯 Admin Dashboard Setup Guide

## Quick Start

### 1. Install Dependencies
```bash
cd admin-dashboard
npm install
```

### 2. Start the Dashboard
```bash
# Option 1: From admin-dashboard folder
npm run dev

# Option 2: From root folder
start-admin-dashboard.bat
```

### 3. Access the Dashboard
- URL: http://localhost:5174
- Login Page: http://localhost:5174/login

### 4. Login Credentials

**Super Admin:**
- Email: `admin@fooddelivery.com`
- Password: `admin123`

**Manager:**
- Email: `manager@fooddelivery.com`
- Password: `manager123`

**Delivery Boy:**
- Email: `delivery@fooddelivery.com`
- Password: `delivery123`

## Features

### Super Admin Dashboard
- Complete system analytics
- Revenue charts
- Order statistics
- User management
- Restaurant management
- Delivery boy management
- Payment & commission tracking
- System settings

### Manager Dashboard
- Restaurant-specific analytics
- Product management
- Order management
- Category management

### Delivery Boy Dashboard
- Available deliveries
- Delivery history
- Earnings tracking
- Online/offline status

## Auto-Redirect After Login

The system automatically redirects users based on their role:
- **Super Admin** → `/super-admin`
- **Manager** → `/manager-dashboard`
- **Delivery Boy** → `/delivery-dashboard`
- **Others** → `/` (Default dashboard)

## API Configuration

The dashboard connects to Laravel API at:
- Base URL: `http://localhost:8000`
- API Endpoint: `http://localhost:8000/api/admin/*`

## Troubleshooting

### Issue: Login not working
1. Make sure Laravel server is running: `php artisan serve`
2. Check if database is seeded: `php artisan db:seed --class=RolePermissionSeeder`
3. Clear browser cache and localStorage

### Issue: 401 Unauthorized
1. Check if token is stored in localStorage
2. Verify API endpoint is correct
3. Re-login to get a fresh token

### Issue: Port already in use
Change port in `admin-dashboard/vite.config.js`:
```js
server: {
  port: 5174, // Change this to another port
}
```

## Development

### Project Structure
```
admin-dashboard/
├── src/
│   ├── components/      # Reusable components
│   ├── views/           # Page components
│   ├── store/           # Pinia stores
│   ├── router/          # Vue Router config
│   ├── plugins/         # Axios config
│   └── assets/          # CSS and images
├── package.json
└── vite.config.js
```

### Available Scripts
```bash
npm run dev      # Start development server
npm run build    # Build for production
npm run preview  # Preview production build
```

## Tech Stack
- Vue 3 (Composition API)
- Vuetify 3 (UI Framework)
- Pinia (State Management)
- Vue Router 4
- Chart.js (Analytics)
- Axios (HTTP Client)
- Vite (Build Tool)
