# Sample API Responses for Food Delivery Admin Dashboard

## Dashboard Analytics

### GET /api/admin/dashboard/analytics
```json
{
  "success": true,
  "data": {
    "stats": {
      "total_restaurants": 156,
      "active_restaurants": 142,
      "pending_restaurants": 14,
      "total_orders": 2847,
      "today_orders": 89,
      "total_revenue": 284750.50,
      "today_revenue": 8950.25,
      "total_users": 12450,
      "active_delivery_boys": 89,
      "total_commission": 42712.58,
      "pending_payouts": 12450.75
    },
    "charts": {
      "revenue_chart": {
        "labels": ["Jan", "Feb", "Mar", "Apr", "May", "Jun"],
        "data": [45000, 52000, 48000, 61000, 58000, 67000]
      },
      "order_chart": {
        "labels": ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"],
        "data": [245, 289, 234, 278, 312, 356, 298]
      },
      "category_distribution": [
        { "name": "Pizza", "value": 35, "color": "#FF6384" },
        { "name": "Burgers", "value": 25, "color": "#36A2EB" },
        { "name": "Asian", "value": 20, "color": "#FFCE56" },
        { "name": "Desserts", "value": 20, "color": "#4BC0C0" }
      ]
    },
    "recent_orders": [
      {
        "id": 12345,
        "order_number": "ORD-2024-001234",
        "customer_name": "John Doe",
        "restaurant_name": "Pizza Palace",
        "total_amount": 45.99,
        "status": "delivered",
        "created_at": "2024-12-17T14:30:00Z"
      },
      {
        "id": 12344,
        "order_number": "ORD-2024-001233",
        "customer_name": "Jane Smith",
        "restaurant_name": "Burger King",
        "total_amount": 32.50,
        "status": "preparing",
        "created_at": "2024-12-17T14:15:00Z"
      }
    ]
  }
}
```

## Restaurant Management

### GET /api/admin/restaurants
```json
{
  "success": true,
  "data": {
    "restaurants": {
      "data": [
        {
          "id": 1,
          "name": "Pizza Palace",
          "slug": "pizza-palace",
          "description": "Best pizza in town",
          "phone": "+1234567890",
          "email": "info@pizzapalace.com",
          "address": "123 Main St, City",
          "latitude": 40.7128,
          "longitude": -74.0060,
          "status": "active",
          "is_featured": true,
          "delivery_fee": 2.99,
          "minimum_order": 15.00,
          "delivery_time": "30-45 min",
          "rating": 4.5,
          "total_reviews": 234,
          "logo": "https://example.com/storage/restaurants/logos/pizza-palace.jpg",
          "cover_image": "https://example.com/storage/restaurants/covers/pizza-palace-cover.jpg",
          "categories": [
            { "id": 1, "name": "Pizza", "slug": "pizza" },
            { "id": 2, "name": "Italian", "slug": "italian" }
          ],
          "owner": {
            "id": 45,
            "name": "Restaurant Owner",
            "email": "owner@pizzapalace.com",
            "phone": "+1234567890"
          },
          "commission": {
            "rate": 15,
            "type": "percentage",
            "is_active": true
          },
          "stats": {
            "total_orders": 1250,
            "total_revenue": 45678.90,
            "average_order_value": 36.54
          },
          "created_at": "2024-01-15T10:00:00Z",
          "updated_at": "2024-12-17T08:30:00Z"
        }
      ],
      "current_page": 1,
      "total_pages": 8,
      "per_page": 15,
      "total": 156,
      "from": 1,
      "to": 15
    }
  }
}
```

### POST /api/admin/restaurants/{id}/approve
```json
{
  "success": true,
  "message": "Restaurant approved successfully",
  "data": {
    "restaurant": {
      "id": 1,
      "name": "Pizza Palace",
      "status": "active",
      "approved_at": "2024-12-17T15:00:00Z",
      "approved_by": {
        "id": 1,
        "name": "Admin User"
      }
    }
  }
}
```

## Product Management

### GET /api/admin/products
```json
{
  "success": true,
  "data": {
    "products": {
      "data": [
        {
          "id": 1,
          "name": "Margherita Pizza",
          "slug": "margherita-pizza",
          "description": "Classic pizza with tomato sauce, mozzarella, and basil",
          "price": 18.99,
          "discounted_price": 16.99,
          "sku": "PIZ-MAR-001",
          "status": "active",
          "is_featured": true,
          "is_vegetarian": true,
          "preparation_time": 20,
          "calories": 850,
          "images": [
            "https://example.com/storage/products/margherita-pizza-1.jpg",
            "https://example.com/storage/products/margherita-pizza-2.jpg"
          ],
          "category": {
            "id": 1,
            "name": "Pizza",
            "slug": "pizza"
          },
          "restaurant": {
            "id": 1,
            "name": "Pizza Palace",
            "slug": "pizza-palace"
          },
          "variants": [
            {
              "id": 1,
              "name": "Small (10\")",
              "price": 14.99,
              "sku": "PIZ-MAR-SM"
            },
            {
              "id": 2,
              "name": "Large (14\")",
              "price": 22.99,
              "sku": "PIZ-MAR-LG"
            }
          ],
          "addons": [
            {
              "id": 1,
              "name": "Extra Cheese",
              "price": 2.50
            },
            {
              "id": 2,
              "name": "Mushrooms",
              "price": 1.50
            }
          ],
          "nutrition": {
            "calories": 850,
            "protein": 35,
            "carbs": 95,
            "fat": 32
          },
          "rating": 4.3,
          "total_reviews": 89,
          "created_at": "2024-02-01T10:00:00Z",
          "updated_at": "2024-12-17T09:15:00Z"
        }
      ],
      "current_page": 1,
      "total_pages": 12,
      "per_page": 20,
      "total": 234,
      "from": 1,
      "to": 20
    }
  }
}
```

## Order Management

### GET /api/admin/orders
```json
{
  "success": true,
  "data": {
    "orders": {
      "data": [
        {
          "id": 12345,
          "order_number": "ORD-2024-001234",
          "customer": {
            "id": 789,
            "name": "John Doe",
            "email": "john@example.com",
            "phone": "+1234567890",
            "avatar": "https://example.com/storage/users/john-avatar.jpg"
          },
          "restaurant": {
            "id": 1,
            "name": "Pizza Palace",
            "phone": "+1234567890"
          },
          "delivery_boy": {
            "id": 45,
            "name": "Mike Johnson",
            "phone": "+1987654321",
            "vehicle_number": "ABC123",
            "current_location": {
              "latitude": 40.7128,
              "longitude": -74.0060
            }
          },
          "items": [
            {
              "id": 1,
              "product_name": "Margherita Pizza",
              "quantity": 2,
              "price": 18.99,
              "total": 37.98,
              "special_instructions": "Extra cheese please"
            },
            {
              "id": 2,
              "product_name": "Garlic Bread",
              "quantity": 1,
              "price": 6.99,
              "total": 6.99,
              "special_instructions": ""
            }
          ],
          "pricing": {
            "subtotal": 44.97,
            "delivery_fee": 2.99,
            "tax": 3.82,
            "discount": 5.00,
            "total": 46.78,
            "commission": 7.02
          },
          "status": "out_for_delivery",
          "status_history": [
            {
              "status": "pending",
              "timestamp": "2024-12-17T14:30:00Z",
              "note": "Order placed"
            },
            {
              "status": "confirmed",
              "timestamp": "2024-12-17T14:35:00Z",
              "note": "Restaurant confirmed"
            },
            {
              "status": "preparing",
              "timestamp": "2024-12-17T14:40:00Z",
              "note": "Being prepared"
            },
            {
              "status": "ready_for_pickup",
              "timestamp": "2024-12-17T15:00:00Z",
              "note": "Ready for pickup"
            },
            {
              "status": "out_for_delivery",
              "timestamp": "2024-12-17T15:05:00Z",
              "note": "Picked up by delivery boy"
            }
          ],
          "delivery_address": {
            "street": "456 Oak Street",
            "city": "New York",
            "state": "NY",
            "zip": "10001",
            "latitude": 40.7589,
            "longitude": -73.9851,
            "instructions": "Ring doorbell twice"
          },
          "payment_method": "card",
          "payment_status": "paid",
          "estimated_delivery_time": "15:30",
          "actual_delivery_time": null,
          "rating": null,
          "feedback": null,
          "created_at": "2024-12-17T14:30:00Z",
          "updated_at": "2024-12-17T15:05:00Z"
        }
      ],
      "current_page": 1,
      "total_pages": 15,
      "per_page": 10,
      "total": 2847,
      "from": 1,
      "to": 10
    }
  }
}
```

### PUT /api/admin/orders/{id}/status
```json
{
  "success": true,
  "message": "Order status updated successfully",
  "data": {
    "order": {
      "id": 12345,
      "order_number": "ORD-2024-001234",
      "status": "delivered",
      "status_history": [
        {
          "status": "pending",
          "timestamp": "2024-12-17T14:30:00Z",
          "note": "Order placed"
        },
        {
          "status": "delivered",
          "timestamp": "2024-12-17T15:25:00Z",
          "note": "Successfully delivered"
        }
      ],
      "actual_delivery_time": "2024-12-17T15:25:00Z"
    }
  }
}
```

## Delivery Boy Management

### GET /api/admin/delivery-boys
```json
{
  "success": true,
  "data": {
    "delivery_boys": {
      "data": [
        {
          "id": 45,
          "name": "Mike Johnson",
          "email": "mike@delivery.com",
          "phone": "+1987654321",
          "avatar": "https://example.com/storage/delivery-boys/mike-avatar.jpg",
          "status": "active",
          "is_available": true,
          "vehicle_type": "motorcycle",
          "vehicle_number": "ABC123",
          "driving_license": "DL123456789",
          "address": "789 Delivery St, City",
          "emergency_contact": {
            "name": "Sarah Johnson",
            "phone": "+1987654322"
          },
          "wallet": {
            "balance": 1250.50,
            "total_earnings": 8450.75,
            "last_payout": "2024-12-10T10:00:00Z"
          },
          "commission": {
            "rate": 10,
            "type": "percentage",
            "is_active": true
          },
          "stats": {
            "total_deliveries": 892,
            "successful_deliveries": 875,
            "cancelled_deliveries": 17,
            "average_rating": 4.7,
            "total_ratings": 456
          },
          "current_location": {
            "latitude": 40.7128,
            "longitude": -74.0060,
            "last_updated": "2024-12-17T14:45:00Z"
          },
          "documents": {
            "license_verified": true,
            "vehicle_insurance": true,
            "background_check": true
          },
          "created_at": "2024-06-01T10:00:00Z",
          "updated_at": "2024-12-17T14:45:00Z"
        }
      ],
      "current_page": 1,
      "total_pages": 6,
      "per_page": 15,
      "total": 89,
      "from": 1,
      "to": 15
    }
  }
}
```

### POST /api/admin/delivery-boys/{id}/payout
```json
{
  "success": true,
  "message": "Payout processed successfully",
  "data": {
    "payout": {
      "id": 789,
      "delivery_boy_id": 45,
      "amount": 1250.50,
      "type": "weekly_payout",
      "status": "completed",
      "payment_method": "bank_transfer",
      "transaction_id": "TXN-2024-001789",
      "processed_at": "2024-12-17T15:00:00Z",
      "processed_by": {
        "id": 1,
        "name": "Admin User"
      },
      "wallet_balance_after": 0.00
    }
  }
}
```

## User Management

### GET /api/admin/users
```json
{
  "success": true,
  "data": {
    "users": {
      "data": [
        {
          "id": 789,
          "name": "John Doe",
          "email": "john@example.com",
          "phone": "+1234567890",
          "avatar": "https://example.com/storage/users/john-avatar.jpg",
          "status": "active",
          "email_verified": true,
          "phone_verified": true,
          "roles": ["customer"],
          "wallet": {
            "balance": 125.50,
            "total_deposited": 850.00,
            "total_spent": 724.50
          },
          "stats": {
            "total_orders": 45,
            "total_spent": 724.50,
            "average_order_value": 16.10,
            "favorite_restaurant": "Pizza Palace",
            "last_order": "2024-12-15T18:30:00Z"
          },
          "addresses": [
            {
              "id": 1,
              "type": "home",
              "street": "456 Oak Street",
              "city": "New York",
              "state": "NY",
              "zip": "10001",
              "is_default": true
            }
          ],
          "created_at": "2024-01-15T10:00:00Z",
          "updated_at": "2024-12-17T10:30:00Z"
        }
      ],
      "current_page": 1,
      "total_pages": 25,
      "per_page": 20,
      "total": 12450,
      "from": 1,
      "to": 20
    }
  }
}
```

### POST /api/admin/users/{id}/wallet/adjust
```json
{
  "success": true,
  "message": "Wallet balance adjusted successfully",
  "data": {
    "user": {
      "id": 789,
      "name": "John Doe",
      "wallet": {
        "balance": 175.50,
        "previous_balance": 125.50,
        "adjustment": 50.00,
        "type": "credit",
        "reason": "Refund for order #12345"
      },
      "transaction": {
        "id": 456,
        "type": "admin_adjustment",
        "amount": 50.00,
        "balance_after": 175.50,
        "description": "Refund for order #12345",
        "created_at": "2024-12-17T15:00:00Z"
      }
    }
  }
}
```

## Payment & Commission Management

### GET /api/admin/payments
```json
{
  "success": true,
  "data": {
    "payments": {
      "data": [
        {
          "id": 123,
          "order_id": 12345,
          "order_number": "ORD-2024-001234",
          "transaction_id": "TXN-2024-001234",
          "payment_method": "stripe",
          "amount": 46.78,
          "status": "completed",
          "type": "order_payment",
          "customer": {
            "id": 789,
            "name": "John Doe",
            "email": "john@example.com"
          },
          "restaurant": {
            "id": 1,
            "name": "Pizza Palace"
          },
          "commission": {
            "admin_commission": 7.02,
            "restaurant_earnings": 39.76,
            "commission_rate": 15
          },
          "payment_details": {
            "card_last_four": "4242",
            "card_brand": "Visa",
            "processing_fee": 1.41
          },
          "created_at": "2024-12-17T14:30:00Z",
          "updated_at": "2024-12-17T14:31:00Z"
        }
      ],
      "current_page": 1,
      "total_pages": 20,
      "per_page": 15,
      "total": 2847,
      "from": 1,
      "to": 15
    }
  }
}
```

### GET /api/admin/commissions/summary
```json
{
  "success": true,
  "data": {
    "summary": {
      "total_commission": 42712.58,
      "this_month": 8450.25,
      "last_month": 7823.15,
      "growth": 8.02,
      "commission_by_type": {
        "restaurant_commission": 38441.32,
        "delivery_commission": 4271.26
      },
      "commission_by_period": {
        "daily": [
          { "date": "2024-12-10", "amount": 1245.50 },
          { "date": "2024-12-11", "amount": 1389.25 },
          { "date": "2024-12-12", "amount": 1156.75 }
        ],
        "monthly": [
          { "month": "Sep 2024", "amount": 6845.20 },
          { "month": "Oct 2024", "amount": 7234.15 },
          { "month": "Nov 2024", "amount": 7823.15 },
          { "month": "Dec 2024", "amount": 8450.25 }
        ]
      }
    }
  }
}
```

## Category Management

### GET /api/admin/categories
```json
{
  "success": true,
  "data": {
    "categories": {
      "data": [
        {
          "id": 1,
          "name": "Pizza",
          "slug": "pizza",
          "description": "Delicious pizzas",
          "image": "https://example.com/storage/categories/pizza.jpg",
          "icon": "🍕",
          "color": "#FF6B6B",
          "parent_id": null,
          "status": "active",
          "is_featured": true,
          "sort_order": 1,
          "stats": {
            "total_restaurants": 45,
            "total_products": 234,
            "average_price": 18.99
          },
          "subcategories": [
            {
              "id": 11,
              "name": "Vegetarian Pizza",
              "slug": "vegetarian-pizza",
              "status": "active"
            },
            {
              "id": 12,
              "name": "Non-Vegetarian Pizza",
              "slug": "non-vegetarian-pizza",
              "status": "active"
            }
          ],
          "created_at": "2024-01-01T00:00:00Z",
          "updated_at": "2024-12-17T08:00:00Z"
        }
      ],
      "current_page": 1,
      "total_pages": 3,
      "per_page": 15,
      "total": 42,
      "from": 1,
      "to": 15
    }
  }
}
```

## Settings Management

### GET /api/admin/settings
```json
{
  "success": true,
  "data": {
    "settings": {
      "general": {
        "site_name": "Food Delivery Admin",
        "site_description": "Admin dashboard for food delivery system",
        "contact_email": "admin@fooddelivery.com",
        "contact_phone": "+1234567890",
        "timezone": "America/New_York",
        "currency": "USD",
        "currency_symbol": "$",
        "date_format": "MM/DD/YYYY",
        "time_format": "12h"
      },
      "commission": {
        "restaurant_commission_rate": 15,
        "delivery_commission_rate": 10,
        "commission_type": "percentage",
        "minimum_payout_amount": 50.00,
        "payout_frequency": "weekly"
      },
      "delivery": {
        "base_delivery_fee": 2.99,
        "delivery_radius": 10,
        "max_delivery_time": 60,
        "auto_assign_delivery_boy": true,
        "delivery_boy_radius": 5
      },
      "payment": {
        "enabled_payment_methods": ["stripe", "paypal", "cash"],
        "stripe_publishable_key": "pk_test_123456789",
        "paypal_client_id": "paypal_client_id_here",
        "minimum_order_amount": 10.00,
        "maximum_order_amount": 500.00
      },
      "notifications": {
        "email_notifications": true,
        "sms_notifications": true,
        "push_notifications": true,
        "admin_email": "admin@fooddelivery.com"
      },
      "maintenance": {
        "maintenance_mode": false,
        "allowed_ips": ["127.0.0.1"],
        "maintenance_message": "We'll be back soon!"
      }
    }
  }
}
```

### PUT /api/admin/settings/bulk-update
```json
{
  "success": true,
  "message": "Settings updated successfully",
  "data": {
    "updated_settings": {
      "general": {
        "site_name": "Food Delivery Admin",
        "timezone": "America/New_York"
      },
      "commission": {
        "restaurant_commission_rate": 15
      }
    }
  }
}
```

## Error Responses

### 401 Unauthorized
```json
{
  "success": false,
  "message": "Unauthenticated. Please login to continue.",
  "error_code": "UNAUTHENTICATED"
}
```

### 403 Forbidden
```json
{
  "success": false,
  "message": "You do not have permission to perform this action.",
  "error_code": "INSUFFICIENT_PERMISSIONS",
  "required_permission": "view-restaurants"
}
```

### 404 Not Found
```json
{
  "success": false,
  "message": "Resource not found.",
  "error_code": "NOT_FOUND"
}
```

### 422 Validation Error
```json
{
  "success": false,
  "message": "The given data was invalid.",
  "errors": {
    "name": ["The name field is required."],
    "email": ["The email must be a valid email address."],
    "phone": ["The phone number must be at least 10 digits."]
  },
  "error_code": "VALIDATION_ERROR"
}
```

### 500 Internal Server Error
```json
{
  "success": false,
  "message": "Something went wrong. Please try again later.",
  "error_code": "INTERNAL_ERROR",
  "request_id": "req_123456789"
}
```