# 🔧 Fix Vite + Laravel Page Issue

## Problem
`http://localhost:5173/` opens default Vite + Laravel page instead of Vue app

## ✅ Solution

### Step 1: Stop All Servers
```bash
# Press Ctrl+C in both terminals
```

### Step 2: Clear Cache
```bash
cd g:\project\laravel\delivery_system
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear
```

### Step 3: Build Assets
```bash
npm run build
```

### Step 4: Start Backend
```bash
php artisan serve
```

### Step 5: Start Frontend (New Terminal)
```bash
npm run dev
```

### Step 6: Access Application
```
http://127.0.0.1:8000
```

**NOT** `http://localhost:5173` (Vite dev server)

---

## 🎯 Correct URLs

### Development Mode

**Use Laravel URL:**
```
http://127.0.0.1:8000/
http://127.0.0.1:8000/login
http://127.0.0.1:8000/super-admin
```

**NOT Vite URL:**
```
❌ http://localhost:5173/
```

---

## 📝 Why?

- Laravel serves the app through `routes/web.php`
- Vite compiles assets (CSS/JS)
- Access through Laravel port (8000), not Vite port (5173)

---

## ⚡ Quick Fix

```bash
# Terminal 1
cd g:\project\laravel\delivery_system
php artisan serve

# Terminal 2
cd g:\project\laravel\delivery_system
npm run dev

# Browser
http://127.0.0.1:8000/
```

---

## ✅ Correct Flow

1. **Open:** `http://127.0.0.1:8000/`
2. **See:** Home page with restaurants
3. **Click:** Login button
4. **Enter:** admin@fooddelivery.com / admin123
5. **Redirect:** `http://127.0.0.1:8000/super-admin`

---

## 🔍 Verify Setup

```bash
# Check if Vite is running
npm run dev
# Should see: VITE v5.x.x ready in xxx ms
# Should see: ➜ Local: http://localhost:5173/

# Check if Laravel is running
php artisan serve
# Should see: Server running on [http://127.0.0.1:8000]

# Open browser
http://127.0.0.1:8000/
```

---

## 🎯 Final URLs

| Page | URL |
|------|-----|
| Home | `http://127.0.0.1:8000/` |
| Login | `http://127.0.0.1:8000/login` |
| Super Admin | `http://127.0.0.1:8000/super-admin` |
| Restaurants | `http://127.0.0.1:8000/restaurants` |

**Always use port 8000 (Laravel), not 5173 (Vite)!** ✅
