# 📱 Delivery Boy Mobile Web App - Installation Guide

## ✅ Phone එකේ Install කරන්නේ කොහොමද?

### 🌐 Method: PWA (Progressive Web App) - Browser එකෙන්

මේක **Flutter install කරන්න ඕනේ නැහැ**! Browser එකෙන් පමණක් install කරන්න පුළුවන්.

---

## 🚀 Quick Setup

### 1️⃣ Laravel Server Start කරන්න

```bash
cd g:\project\laravel\delivery_system

# Computer IP එකෙන් access කරන්න පුළුවන් විදියට
php artisan serve --host=0.0.0.0 --port=8000
```

### 2️⃣ Computer IP එක හොයාගන්න

```bash
ipconfig
```

**IPv4 Address:** `192.168.8.179` (ඔබේ IP එක)

### 3️⃣ Phone Browser එකෙන් Open කරන්න

Phone එකේ Chrome/Safari browser එක open කරලා:

```
http://192.168.8.179:8000/delivery-boy
```

---

## 📲 Phone එකේ Install කරන්න

### Android (Chrome):

1. Browser එකෙන් site එක open කරන්න
2. Menu (⋮) → **"Add to Home screen"** click කරන්න
3. **"Add"** click කරන්න
4. App icon එක home screen එකේ පෙන්වයි! 🎉

### iPhone (Safari):

1. Safari එකෙන් site එක open කරන්න
2. Share button (□↑) click කරන්න
3. **"Add to Home Screen"** select කරන්න
4. **"Add"** click කරන්න
5. App icon එක home screen එකේ පෙන්වයි! 🎉

---

## 🎯 Features

### ✅ Mobile-First Design
- Phone එකට optimize කරපු UI
- Touch-friendly buttons
- Smooth animations
- Fast loading

### ✅ Available Orders Tab
- නව delivery orders බලන්න
- Restaurant & customer details
- Order accept කරන්න
- Pull to refresh

### ✅ My Orders Tab
- Active deliveries track කරන්න
- Customer ට call කරන්න (direct phone link)
- Google Maps navigation
- Status update කරන්න

### ✅ Earnings Tab
- Today, Week, Month earnings
- Total deliveries count
- Real-time updates

### ✅ Order Details Modal
- Full order information
- Call customer button
- Open in Google Maps
- Accept/Pick Up/Delivered buttons

---

## 🔑 Login Details

```
Email: delivery@example.com
Password: password
```

---

## 📱 App Features

### 1. Login Screen
- Simple email/password login
- Orange gradient design
- Auto-save token

### 2. Bottom Navigation
- 📋 Available Orders
- 🚚 My Orders
- 💰 Earnings

### 3. Order Cards
- Order number & amount
- Restaurant name
- Customer name & address
- Delivery fee highlighted

### 4. Order Actions
- **Available Orders** → Accept
- **Ready** → Pick Up
- **Picked Up** → Mark as Delivered

### 5. Quick Actions
- 📞 Call customer (direct phone link)
- 🗺️ Open in Google Maps
- 🔄 Pull to refresh

---

## ⚙️ Requirements

### Phone:
- Android 5.0+ හෝ iOS 11.0+
- Chrome/Safari browser
- Internet connection (WiFi/Mobile Data)

### Computer:
- Laravel server running
- Same network (WiFi) හෝ accessible IP

---

## 🔧 Troubleshooting

### Site එක load වෙන්නේ නැහැ

1. **Laravel server run වෙනවද check කරන්න:**
```bash
php artisan serve --host=0.0.0.0
```

2. **Phone එකත් computer එකත් same WiFi network එකේද check කරන්න**

3. **Computer firewall disable කරන්න (temporarily):**
   - Windows Defender Firewall → Turn off

4. **Browser එකෙන් test කරන්න:**
```
http://192.168.8.179:8000/api/restaurants
```

### "Add to Home Screen" option එක නැහැ

- Chrome browser use කරන්න (Android)
- Safari browser use කරන්න (iOS)
- HTTPS නැතිව HTTP use කරන්න local development එකට

### Login වෙන්නේ නැහැ

1. Database එකේ delivery boy user එක තියෙනවද check කරන්න:
```bash
php artisan tinker
User::where('email', 'delivery@example.com')->first();
```

2. නැත්නම් create කරන්න:
```bash
php artisan db:seed --class=UserSeeder
```

### API calls fail වෙනවා

1. Browser console එක check කරන්න (F12)
2. Network tab එකෙන් failed requests බලන්න
3. Laravel logs check කරන්න: `storage/logs/laravel.log`

---

## 🎨 Customization

### App Name වෙනස් කරන්න

`public/manifest.json` file එකේ:
```json
{
  "name": "Your App Name",
  "short_name": "App"
}
```

### Theme Color වෙනස් කරන්න

`resources/js/views/DeliveryBoy/MobileApp.vue` file එකේ:
```css
.login { background: linear-gradient(135deg, #your-color, #your-color); }
.header { background: #your-color; }
```

---

## 📊 Comparison: Flutter App vs Web App

| Feature | Flutter App | Web App (PWA) |
|---------|-------------|---------------|
| Installation | APK build කරන්න ඕනේ | Browser එකෙන් instant |
| Size | ~20-30 MB | ~1-2 MB |
| Updates | APK ආයේ install කරන්න ඕනේ | Auto update |
| Offline | Full offline support | Limited offline |
| Performance | Native speed | Near-native |
| Development | Flutter SDK ඕනේ | Browser පමණක් |

---

## ✅ Advantages of Web App

1. **No Installation Required** - Browser එකෙන් පමණක්
2. **Instant Updates** - Code change කළාම auto update
3. **Cross-Platform** - Android, iOS, Desktop
4. **Smaller Size** - APK වගේ large file එකක් නැහැ
5. **Easy Sharing** - URL එක share කරන්න පුළුවන්
6. **No App Store** - Google Play/App Store එකට upload කරන්න ඕනේ නැහැ

---

## 🚀 Access URLs

```
Local Computer:
http://localhost:8000/delivery-boy

Same Network (Phone):
http://192.168.8.179:8000/delivery-boy

Production (After Deploy):
https://yourdomain.com/delivery-boy
```

---

## 📞 Support

Issues තියෙනවනම්:
1. Browser console check කරන්න (F12)
2. Laravel logs: `storage/logs/laravel.log`
3. Network tab එකෙන් API calls check කරන්න

---

**සාර්ථකයි! Phone එකේ app එක install කරන්න ready!** 🎉📱

## 🎯 Next Steps

1. Browser එකෙන් `/delivery-boy` open කරන්න
2. "Add to Home Screen" click කරන්න
3. Login කරන්න
4. Orders manage කරන්න

**Done!** 🚀
