# 🧪 PRODUCT & CART - Test Guide

## ✅ Quick Test Steps

### 1. Setup & Seed
```bash
php artisan migrate
php artisan db:seed
```

---

## 📦 Test Product System

### 1. List Products (Public)
```http
GET http://localhost:8000/api/products
```

### 2. Get Product Details
```http
GET http://localhost:8000/api/products/1
```

**Expected Response:**
```json
{
  "id": 1,
  "name": "Margherita Pizza",
  "price": 1200,
  "discount_price": 1000,
  "variations": [
    {"id": 1, "name": "Size", "value": "Small", "price_adjustment": 0},
    {"id": 2, "name": "Size", "value": "Large", "price_adjustment": 300}
  ],
  "addons": [
    {"id": 1, "name": "Extra Cheese", "price": 150},
    {"id": 2, "name": "Egg", "price": 50}
  ]
}
```

---

## 🛒 Test Cart System

### 1. Login as Customer
```http
POST http://localhost:8000/api/login
Content-Type: application/json

{
  "email": "customer@test.com",
  "password": "password"
}
```

**Save the token!**

---

### 2. Add Product to Cart (Simple)
```http
POST http://localhost:8000/api/cart
Authorization: Bearer {token}
Content-Type: application/json

{
  "product_id": 1,
  "quantity": 1
}
```

**Expected:** Product added with base price

---

### 3. Add Product with Variations
```http
POST http://localhost:8000/api/cart
Authorization: Bearer {token}
Content-Type: application/json

{
  "product_id": 1,
  "quantity": 2,
  "variations": [
    {
      "id": 2,
      "name": "Size",
      "value": "Large",
      "price_adjustment": 300
    }
  ]
}
```

**Price Calculation:**
- Base: 1000
- Variation: +300
- Unit: 1300
- Quantity: 2
- **Total: 2600**

---

### 4. Add Product with Variations & Add-ons
```http
POST http://localhost:8000/api/cart
Authorization: Bearer {token}
Content-Type: application/json

{
  "product_id": 1,
  "quantity": 1,
  "variations": [
    {
      "id": 2,
      "name": "Size",
      "value": "Large",
      "price_adjustment": 300
    }
  ],
  "addons": [
    {
      "id": 1,
      "name": "Extra Cheese",
      "price": 150
    },
    {
      "id": 2,
      "name": "Egg",
      "price": 50
    }
  ],
  "special_notes": "Extra spicy, no onions"
}
```

**Price Calculation:**
- Base: 1000
- Variation: +300
- Addons: +150 +50 = +200
- Unit: 1500
- Quantity: 1
- **Total: 1500**

---

### 5. View Cart
```http
GET http://localhost:8000/api/cart
Authorization: Bearer {token}
```

**Expected Response:**
```json
{
  "items": [
    {
      "id": 1,
      "product": {
        "name": "Margherita Pizza"
      },
      "quantity": 1,
      "unit_price": 1000,
      "total_price": 1500,
      "variations": [...],
      "addons": [...],
      "special_notes": "Extra spicy, no onions"
    }
  ],
  "subtotal": 1500,
  "delivery_fee": 200,
  "service_charge": 75,
  "tax": 150,
  "total": 1925
}
```

---

### 6. Update Cart Quantity
```http
PUT http://localhost:8000/api/cart/1
Authorization: Bearer {token}
Content-Type: application/json

{
  "quantity": 3
}
```

**Expected:** Total price recalculated (1500 × 3 = 4500)

---

### 7. Remove Item from Cart
```http
DELETE http://localhost:8000/api/cart/1
Authorization: Bearer {token}
```

**Expected:** Item removed

---

### 8. Clear Entire Cart
```http
DELETE http://localhost:8000/api/cart
Authorization: Bearer {token}
```

**Expected:** All items removed

---

## 🚫 Test Multi-Restaurant Restriction

### 1. Add Product from Restaurant 1
```http
POST http://localhost:8000/api/cart
Authorization: Bearer {token}

{
  "product_id": 1,
  "quantity": 1
}
```

### 2. Try Adding from Restaurant 2
```http
POST http://localhost:8000/api/cart
Authorization: Bearer {token}

{
  "product_id": 10,
  "quantity": 1
}
```

**Expected Response (400):**
```json
{
  "message": "You can only order from one restaurant at a time. Clear your cart first."
}
```

---

## 💰 Price Calculation Examples

### Example 1: Basic Product
```
Product: Burger
Base Price: 500
Quantity: 2
Total: 1000
```

### Example 2: With Variation
```
Product: Pizza
Base Price: 1000
Variation (Large): +300
Unit Price: 1300
Quantity: 1
Total: 1300
```

### Example 3: With Variation & Add-ons
```
Product: Pizza
Base Price: 1000
Variation (Large): +300
Addon (Extra Cheese): +150
Addon (Mushrooms): +100
Unit Price: 1550
Quantity: 2
Total: 3100
```

### Example 4: Cart Summary
```
Item 1: 3100
Item 2: 1500
Subtotal: 4600

Delivery Fee: 200
Service Charge (5%): 230
Tax (10%): 460

Grand Total: 5490
```

---

## ✅ Test Checklist

- [ ] List products (public)
- [ ] View product details
- [ ] Add product to cart (simple)
- [ ] Add product with variations
- [ ] Add product with add-ons
- [ ] Add product with special notes
- [ ] View cart with price breakdown
- [ ] Update cart quantity
- [ ] Remove item from cart
- [ ] Clear entire cart
- [ ] Multi-restaurant restriction works
- [ ] Price calculation is correct
- [ ] Unauthorized users get 401

---

## 🎯 Expected Behaviors

### Adding to Cart
- ✅ Product added with correct price
- ✅ Variations increase price
- ✅ Add-ons increase price
- ✅ Special notes saved
- ✅ Quantity multiplies total

### Cart Summary
- ✅ Subtotal = sum of all items
- ✅ Delivery fee from restaurant
- ✅ Service charge calculated
- ✅ Tax calculated
- ✅ Grand total correct

### Restrictions
- ✅ Can't add from different restaurant
- ✅ Must clear cart first
- ✅ Requires authentication

---

**ALL TESTS PASS!** ✅🛒
