# 🍕 Modern Product Management System

## Overview
Restaurant managers සඳහා සම්පූර්ණ product management system එකක් modern UI එකක් සමඟ.

## Features

### ✨ Main Features
- ✅ Product CRUD operations (Create, Read, Update, Delete)
- ✅ Image upload with preview
- ✅ Category management
- ✅ Product variations (Size, Spice level, etc.)
- ✅ Add-ons (Extra cheese, toppings, etc.)
- ✅ Discount support
- ✅ Availability toggle
- ✅ Search & filter by category
- ✅ Responsive grid layout
- ✅ Modern card design

### 🎨 UI Components
- Product cards with images
- Modal forms for add/edit
- Real-time search
- Category filter dropdown
- Discount badges
- Availability indicators

## Installation

### 1. Run Migration
```bash
php artisan migrate
```

### 2. Create Storage Link
```bash
php artisan storage:link
```

### 3. Set Permissions
```bash
chmod -R 775 storage
chmod -R 775 bootstrap/cache
```

## Usage

### Manager Access
1. Login as Manager role
2. Navigate to `/manager/products`
3. Add, edit, or delete products

### API Endpoints

#### Get Products
```
GET /api/manager/products
```

#### Create Product
```
POST /api/manager/products
Content-Type: multipart/form-data

{
  "name": "Chicken Burger",
  "description": "Delicious chicken burger",
  "category_id": 1,
  "price": 850.00,
  "discount": 10,
  "preparation_time": 15,
  "image": [file],
  "is_available": true,
  "variations": [
    {"name": "Size", "value": "Large", "price": 200}
  ],
  "addons": [
    {"name": "Extra Cheese", "price": 100}
  ]
}
```

#### Update Product
```
PUT /api/manager/products/{id}
Content-Type: multipart/form-data
```

#### Toggle Availability
```
PATCH /api/manager/products/{id}/availability
{
  "is_available": false
}
```

#### Delete Product
```
DELETE /api/manager/products/{id}
```

## Database Structure

### Products Table
- `id` - Primary key
- `restaurant_id` - Foreign key to restaurants
- `category_id` - Foreign key to categories
- `name` - Product name
- `slug` - URL-friendly name
- `description` - Product description
- `image` - Image path
- `price` - Base price
- `discount` - Discount percentage
- `preparation_time` - Time in minutes
- `is_available` - Availability status
- `is_active` - Active status

### Product Variations Table
- `id` - Primary key
- `product_id` - Foreign key to products
- `name` - Variation name (e.g., "Size")
- `value` - Variation value (e.g., "Large")
- `price` - Extra price

### Product Addons Table
- `id` - Primary key
- `product_id` - Foreign key to products
- `name` - Addon name
- `price` - Addon price

## File Structure

```
resources/js/components/Manager/
├── Products.vue          # Main product management component
├── Categories.vue        # Category management
└── Layout.vue           # Manager layout

app/Http/Controllers/API/Manager/
└── ProductController.php # Product API controller

app/Models/
├── Product.php          # Product model
├── ProductVariation.php # Variation model
└── ProductAddon.php     # Addon model
```

## Screenshots

### Product Grid View
- Modern card layout
- Image thumbnails
- Quick actions (Edit, Toggle, Delete)
- Discount badges
- Availability indicators

### Add/Edit Modal
- Full form with validation
- Image upload with preview
- Dynamic variations
- Dynamic add-ons
- Category selection

## Tips

### Image Upload
- Supported formats: JPG, PNG, GIF
- Max size: 2MB
- Images stored in `storage/app/public/products/`

### Variations
- Add multiple variations per product
- Each variation has name, value, and extra price
- Example: Size (Small, Medium, Large)

### Add-ons
- Add multiple add-ons per product
- Each addon has name and price
- Example: Extra Cheese, Extra Sauce

### Discount
- Enter percentage (0-100)
- Automatically shows discount badge
- Calculated on frontend

## Troubleshooting

### Images not showing?
```bash
php artisan storage:link
```

### Permission denied?
```bash
chmod -R 775 storage
```

### Migration errors?
```bash
php artisan migrate:fresh --seed
```

## Future Enhancements
- [ ] Bulk operations
- [ ] Product import/export
- [ ] Advanced analytics
- [ ] Stock management
- [ ] Product reviews
- [ ] Image gallery (multiple images)
- [ ] SEO optimization

---

**Built with ❤️ for Restaurant Managers**
