# ⚡ Quick Access Guide

## 🚀 Start Application

```bash
# Terminal 1 - Backend
cd g:\project\laravel\delivery_system
php artisan serve

# Terminal 2 - Frontend
cd g:\project\laravel\delivery_system
npm run dev
```

---

## 🌐 URLs

### Public Pages
- **Home:** `http://localhost:5173/`
- **Restaurants:** `http://localhost:5173/restaurants`
- **Login:** `http://localhost:5173/login`
- **Register:** `http://localhost:5173/register`

### Super Admin
- **Dashboard:** `http://localhost:5173/super-admin`
- **Restaurants:** `http://localhost:5173/super-admin/restaurants`
- **Orders:** `http://localhost:5173/super-admin/orders`
- **Payments:** `http://localhost:5173/super-admin/payments`
- **Users:** `http://localhost:5173/super-admin/users`
- **Settings:** `http://localhost:5173/super-admin/settings`

### Admin
- **Dashboard:** `http://localhost:5173/admin/dashboard`

### Manager
- **Dashboard:** `http://localhost:5173/manager/dashboard`

### Delivery Boy
- **Dashboard:** `http://localhost:5173/delivery/dashboard`

### Customer
- **Dashboard:** `http://localhost:5173/customer/dashboard`

---

## 🔑 Login Credentials

| Role | Email | Password | Dashboard |
|------|-------|----------|-----------|
| **Super Admin** | admin@fooddelivery.com | admin123 | `/super-admin` |
| **Admin** | admin2@fooddelivery.com | admin123 | `/admin/dashboard` |
| **Manager** | manager@fooddelivery.com | manager123 | `/manager/dashboard` |
| **Delivery Boy** | delivery@fooddelivery.com | delivery123 | `/delivery/dashboard` |
| **Customer** | customer@fooddelivery.com | customer123 | `/customer/dashboard` |

---

## 📱 Access Flow

### For Super Admin:

1. **Open:** `http://localhost:5173/`
2. **Click:** "Login" button (top right)
3. **Enter:**
   - Email: `admin@fooddelivery.com`
   - Password: `admin123`
4. **Auto Redirect:** `http://localhost:5173/super-admin`

### Direct Access:

```
http://localhost:5173/login
↓ (Login as Super Admin)
http://localhost:5173/super-admin
```

---

## 🎯 Super Admin Features

From dashboard, access:
- 🏪 **Manage Restaurants** - View, suspend, activate
- 📦 **Manage Orders** - View, update status
- 💳 **Manage Payments** - Track transactions
- 👥 **Manage Users** - Block, unblock users
- ⚙️ **System Settings** - Configure system
- 📊 **Charts** - Revenue & order analytics

---

## 🔧 Quick Commands

```bash
# Seed database
php artisan db:seed --class=RolePermissionSeeder

# Clear cache
php artisan cache:clear

# Restart servers
Ctrl+C (both terminals)
php artisan serve
npm run dev
```

---

## ✅ Quick Test

```bash
# 1. Start servers
php artisan serve & npm run dev

# 2. Open browser
http://localhost:5173/

# 3. Click "Login"

# 4. Enter credentials
admin@fooddelivery.com / admin123

# 5. Should see
Super Admin Dashboard with stats & charts
```

---

**Home page (`/`) → Login → Super Admin Dashboard** ✅
