# 🍔 Food Delivery System - Complete Solution

[![Laravel](https://img.shields.io/badge/Laravel-10.x-red.svg)](https://laravel.com)
[![Vue](https://img.shields.io/badge/Vue-3.x-green.svg)](https://vuejs.org)
[![License](https://img.shields.io/badge/license-Proprietary-blue.svg)](LICENSE)

## 📋 Overview

A production-ready, scalable food delivery platform similar to Uber Eats / PickMe Food, built with Laravel 10 (Backend API) and Vue 3 (Frontend SPA). The system supports multiple restaurants, real-time order tracking, role-based access control, and map-based delivery distance calculation.

## ✨ Key Features

### 🔐 Authentication & Security
- Laravel Sanctum API authentication
- Email/Phone login support
- Role-based access control (Spatie Permission)
- API rate limiting
- Secure token storage

### 🏪 Restaurant Management
- Admin approval system
- Restaurant profiles with images
- Opening/closing hours
- Delivery radius configuration
- Status management (Open/Closed/Busy)

### 🍕 Advanced Product System
- Product categories
- Variations (Size, Spice level)
- Add-ons (Extra cheese, toppings)
- Discount & offer support
- Availability control

### 🛒 Smart Cart System
- Add products with variations & add-ons
- Special notes support
- Auto price calculation
- Cart persistence (LocalStorage + DB)
- Minimum order validation
- Tax & service charge support

### 📦 Order Management
- Complete order lifecycle tracking
- Status: Pending → Accepted → Preparing → Ready → Picked Up → Delivered
- Time-based cancellation rules
- Order notes (Customer → Kitchen → Delivery)
- Invoice generation (PDF)

### 🗺️ Map-Based Delivery
- Google Maps integration
- Auto-detect current location
- Distance calculation (Haversine formula)
- Dynamic delivery fee calculation
- Estimated delivery time
- Live delivery tracking

### 🚴 Delivery Boy Management
- Online/Offline status
- Auto-assign nearest delivery boy
- Manual assignment option
- Commission calculation
- Delivery history
- Wallet & payout tracking

### 💳 Payment System
- Cash on Delivery
- Online payments (Stripe/PayHere)
- Digital wallet system
- Refund handling
- Commission deduction

### 📊 Admin Dashboard
- Total orders & daily income
- Restaurant earnings
- Delivery boy commissions
- Active users statistics
- Map view of live orders
- Reports (CSV/PDF export)

### 🎨 Vue.js Frontend
- Vue 3 + Composition API
- Pinia state management
- Axios API integration
- Mobile-first responsive UI
- Lazy loading & code splitting
- Skeleton loaders
- Toast notifications

### ⚡ Real-Time Features
- WebSockets / Laravel Echo
- Live order status updates
- Real-time delivery tracking
- Push notifications

### 🧠 Advanced Features
- AI-based delivery time estimation
- Surge pricing (busy hours)
- Multi-language support
- Multi-restaurant cart restriction
- Scheduled orders
- Promo codes & loyalty points
- Dark mode
- PWA support

## 🛠️ Tech Stack

### Backend
- **Framework**: Laravel 10
- **Authentication**: Laravel Sanctum
- **Permissions**: Spatie Laravel Permission
- **Database**: MySQL
- **Cache**: Redis
- **Queue**: Redis/Database
- **Storage**: Local/S3/DigitalOcean Spaces

### Frontend
- **Framework**: Vue 3 (Composition API)
- **State Management**: Pinia
- **Routing**: Vue Router 4
- **HTTP Client**: Axios
- **Styling**: Tailwind CSS
- **Build Tool**: Vite
- **Maps**: Google Maps API

## 📦 Installation

Please refer to [SETUP.md](SETUP.md) for detailed installation instructions.

### Quick Start

```bash
# Clone repository
git clone <repository-url>
cd delivery_system

# Install dependencies
composer install
npm install

# Environment setup
cp .env.example .env
php artisan key:generate

# Database setup
php artisan migrate
php artisan db:seed

# Start development servers
php artisan serve
npm run dev
```

## 📁 Project Structure

```
delivery_system/
├── app/
│   ├── Http/Controllers/API/    # API Controllers
│   ├── Models/                  # Eloquent Models
│   ├── Services/                # Business Logic
│   ├── Repositories/            # Data Access Layer
│   └── Notifications/           # Notification Classes
├── database/
│   ├── migrations/              # Database Migrations
│   ├── seeders/                 # Database Seeders
│   └── factories/               # Model Factories
├── resources/
│   ├── js/
│   │   ├── components/          # Vue Components
│   │   ├── views/               # Vue Pages
│   │   ├── stores/              # Pinia Stores
│   │   ├── router/              # Vue Router
│   │   └── services/            # API Services
│   └── css/                     # Stylesheets
├── routes/
│   ├── api.php                  # API Routes
│   └── web.php                  # Web Routes
└── tests/                       # Unit & Feature Tests
```

## 🎯 User Roles

1. **Admin** - Full system access, manage all resources
2. **Manager** - Restaurant owner, manage restaurant & products
3. **Cashier** - Process orders, manage order status
4. **Delivery Boy** - Accept deliveries, update delivery status
5. **Customer** - Browse restaurants, place orders, track deliveries

## 🔌 API Documentation

API documentation is available at `/api/documentation` when running in development mode.

### Key Endpoints

- `POST /api/register` - User registration
- `POST /api/login` - User login
- `GET /api/restaurants` - List restaurants
- `GET /api/products` - List products
- `POST /api/cart` - Add to cart
- `POST /api/orders` - Create order
- `GET /api/orders/{id}/track` - Track order

## 🧪 Testing

```bash
# Run all tests
php artisan test

# Run specific test suite
php artisan test --testsuite=Feature

# Run with coverage
php artisan test --coverage
```

## 🚀 Deployment

### Production Checklist

- [ ] Set `APP_ENV=production`
- [ ] Set `APP_DEBUG=false`
- [ ] Configure database credentials
- [ ] Set up SSL certificate
- [ ] Configure queue workers
- [ ] Set up Redis caching
- [ ] Configure cloud storage
- [ ] Set up monitoring (Sentry)
- [ ] Configure backup system
- [ ] Set up CDN

### Deployment Commands

```bash
# Optimize for production
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Build frontend assets
npm run build

# Run migrations
php artisan migrate --force
```

## 📊 Database Schema

The system includes 15+ comprehensive database tables:

- `users` - User accounts
- `restaurants` - Restaurant profiles
- `products` - Product catalog
- `product_variations` - Size, spice levels
- `product_addons` - Extra toppings
- `carts` - Shopping carts
- `orders` - Order management
- `order_items` - Order details
- `deliveries` - Delivery tracking
- `delivery_boys` - Delivery personnel
- `payments` - Payment transactions
- `wallets` - Digital wallets
- `reviews` - Ratings & reviews
- `promo_codes` - Discount codes
- `notifications` - System notifications

## 🤝 Contributing

This is a proprietary project. Contributions are managed internally.

## 📄 License

Proprietary - All rights reserved

## 📞 Support

For support and questions:
- Email: support@example.com
- Documentation: [Link to docs]
- Issue Tracker: [Link to issues]

## 🙏 Acknowledgments

- Laravel Framework
- Vue.js Team
- Spatie for Laravel Permission
- Google Maps Platform
- All open-source contributors

---

**Built with ❤️ for the food delivery industry**
