<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Restaurant;

class SetupManagerRestaurant extends Command
{
    protected $signature = 'setup:manager-restaurant';
    protected $description = 'Setup restaurant for manager user';

    public function handle()
    {
        $user = User::where('email', 'manager@test.com')->first();
        
        if (!$user) {
            $this->error('Manager user not found');
            return;
        }

        if ($user->restaurant) {
            $this->info('Restaurant already exists');
            return;
        }

        Restaurant::create([
            'user_id' => $user->id,
            'name' => 'Test Restaurant',
            'description' => 'Test Restaurant Description',
            'address' => 'Colombo 07',
            'phone' => '0771234567',
            'latitude' => 6.9271,
            'longitude' => 79.8612,
            'status' => 'approved'
        ]);

        $this->info('Restaurant created successfully!');
    }
}
