<?php

namespace App\Exceptions;

use Exception;

class InvalidStatusTransitionException extends Exception
{
    protected $currentStatus;
    protected $attemptedStatus;

    public function __construct(string $currentStatus, string $attemptedStatus)
    {
        $this->currentStatus = $currentStatus;
        $this->attemptedStatus = $attemptedStatus;
        
        parent::__construct("Invalid status transition from '{$currentStatus}' to '{$attemptedStatus}'");
    }

    public function getCurrentStatus(): string
    {
        return $this->currentStatus;
    }

    public function getAttemptedStatus(): string
    {
        return $this->attemptedStatus;
    }
}