<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Restaurant;
use App\Models\Order;
use App\Models\DeliveryBoy;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class AdminTestController extends Controller
{
    public function createTestAdmin()
    {
        try {
            // Create admin user
            $admin = User::firstOrCreate(
                ['email' => 'admin@test.com'],
                [
                    'name' => 'Test Admin',
                    'password' => Hash::make('password'),
                    'phone' => '+1234567890',
                    'email_verified_at' => now(),
                ]
            );

            // Assign admin role
            $adminRole = Role::firstOrCreate(['name' => 'admin', 'guard_name' => 'sanctum']);
            $userRoles = $admin->roles->pluck('name')->toArray();
            if (!in_array('admin', $userRoles)) {
                $admin->assignRole($adminRole);
            }

            // Create token
            $token = $admin->createToken('admin-token')->plainTextToken;

            return response()->json([
                'success' => true,
                'message' => 'Test admin created successfully',
                'data' => [
                    'user' => $admin,
                    'token' => $token,
                    'login_url' => '/admin/dashboard'
                ]
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to create test admin: ' . $e->getMessage()
            ], 500);
        }
    }

    public function testDashboardData()
    {
        try {
            // Create some test data if needed
            $this->createTestData();

            // Test dashboard endpoint
            $adminController = new AdminController();
            $dashboardData = $adminController->dashboard();

            return response()->json([
                'success' => true,
                'message' => 'Dashboard data retrieved successfully',
                'data' => $dashboardData->getData()
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to get dashboard data: ' . $e->getMessage()
            ], 500);
        }
    }

    private function createTestData()
    {
        // Create test restaurant if none exists
        if (Restaurant::count() === 0) {
            $manager = User::firstOrCreate(
                ['email' => 'manager@test.com'],
                [
                    'name' => 'Test Manager',
                    'password' => Hash::make('password'),
                    'phone' => '+1234567891',
                ]
            );

            $managerRole = Role::firstOrCreate(['name' => 'manager']);
            $manager->assignRole($managerRole);

            Restaurant::create([
                'name' => 'Test Restaurant',
                'description' => 'A test restaurant for demo purposes',
                'address' => '123 Test Street',
                'phone' => '+1234567892',
                'email' => 'restaurant@test.com',
                'latitude' => 40.7128,
                'longitude' => -74.0060,
                'delivery_radius' => 5.0,
                'minimum_order' => 10.00,
                'delivery_fee' => 2.50,
                'status' => 'approved',
                'manager_id' => $manager->id,
            ]);
        }

        // Create test delivery boy if none exists
        if (DeliveryBoy::count() === 0) {
            $deliveryUser = User::firstOrCreate(
                ['email' => 'delivery@test.com'],
                [
                    'name' => 'Test Delivery Boy',
                    'password' => Hash::make('password'),
                    'phone' => '+1234567893',
                ]
            );

            $deliveryRole = Role::firstOrCreate(['name' => 'delivery-boy']);
            $deliveryUser->assignRole($deliveryRole);

            DeliveryBoy::create([
                'user_id' => $deliveryUser->id,
                'vehicle_type' => 'motorcycle',
                'license_number' => 'TEST123',
                'status' => 'available',
                'commission_rate' => 15.00,
            ]);
        }
    }
}