<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Restaurant;
use App\Models\Order;
use App\Models\Delivery;
use App\Models\DeliveryBoy;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardTestController extends Controller
{
    public function testAdminDashboard()
    {
        return response()->json([
            'total_restaurants' => Restaurant::count(),
            'active_restaurants' => Restaurant::where('status', 'approved')->count(),
            'pending_restaurants' => Restaurant::where('status', 'pending')->count(),
            'total_orders' => Order::count(),
            'today_orders' => Order::whereDate('created_at', today())->count(),
            'total_revenue' => Order::where('payment_status', 'paid')->sum('total'),
            'today_revenue' => Order::where('payment_status', 'paid')->whereDate('created_at', today())->sum('total'),
        ]);
    }

    public function testManagerDashboard(Request $request)
    {
        $managerRestaurants = Restaurant::where('manager_id', $request->user()->id)->pluck('id');
        
        return response()->json([
            'total_restaurants' => Restaurant::where('manager_id', $request->user()->id)->count(),
            'active_restaurants' => Restaurant::where('manager_id', $request->user()->id)->where('status', 'approved')->count(),
            'pending_restaurants' => Restaurant::where('manager_id', $request->user()->id)->where('status', 'pending')->count(),
            'total_orders' => Order::whereIn('restaurant_id', $managerRestaurants)->count(),
            'today_orders' => Order::whereIn('restaurant_id', $managerRestaurants)->whereDate('created_at', today())->count(),
            'total_revenue' => Order::whereIn('restaurant_id', $managerRestaurants)->where('payment_status', 'paid')->sum('total'),
            'today_revenue' => Order::whereIn('restaurant_id', $managerRestaurants)->where('payment_status', 'paid')->whereDate('created_at', today())->sum('total'),
        ]);
    }

    public function testDeliveryBoyDashboard(Request $request)
    {
        $deliveryBoy = DeliveryBoy::where('user_id', $request->user()->id)->first();
        
        if (!$deliveryBoy) {
            return response()->json([
                'error' => 'Delivery boy profile not found'
            ], 404);
        }

        return response()->json([
            'total_deliveries' => Delivery::where('delivery_boy_id', $deliveryBoy->id)->count(),
            'today_deliveries' => Delivery::where('delivery_boy_id', $deliveryBoy->id)->whereDate('created_at', today())->count(),
            'completed_today' => Delivery::where('delivery_boy_id', $deliveryBoy->id)->where('status', 'delivered')->whereDate('delivered_at', today())->count(),
            'pending_today' => Delivery::where('delivery_boy_id', $deliveryBoy->id)->whereIn('status', ['assigned', 'picked_up', 'on_the_way'])->whereDate('created_at', today())->count(),
            'total_earnings' => $deliveryBoy->total_earnings,
            'today_earnings' => Delivery::where('delivery_boy_id', $deliveryBoy->id)->where('status', 'delivered')->whereDate('delivered_at', today())->sum('delivery_boy_earning'),
            'available_deliveries' => Delivery::where('status', 'pending')->count(),
        ]);
    }
}