<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class SimpleTestController extends Controller
{
    public function setupTestUsers()
    {
        // Create test admin user
        $admin = User::firstOrCreate([
            'email' => 'admin@example.com'
        ], [
            'name' => 'Test Admin',
            'password' => Hash::make('password123'),
            'email_verified_at' => now(),
        ]);
        
        // Create test manager user
        $manager = User::firstOrCreate([
            'email' => 'manager@example.com'
        ], [
            'name' => 'Test Manager',
            'password' => Hash::make('password123'),
            'email_verified_at' => now(),
        ]);
        
        // Create test delivery boy user
        $deliveryBoy = User::firstOrCreate([
            'email' => 'delivery@example.com'
        ], [
            'name' => 'Test Delivery Boy',
            'password' => Hash::make('password123'),
            'email_verified_at' => now(),
        ]);
        
        return response()->json([
            'message' => 'Test users created successfully',
            'users' => [
                'admin' => ['email' => 'admin@example.com', 'password' => 'password123'],
                'manager' => ['email' => 'manager@example.com', 'password' => 'password123'],
                'delivery_boy' => ['email' => 'delivery@example.com', 'password' => 'password123'],
            ]
        ]);
    }

    public function testAuth()
    {
        return response()->json([
            'user' => auth()->user(),
            'authenticated' => auth()->check(),
        ]);
    }
}