<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRestaurantRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'sometimes|string|max:255',
            'description' => 'nullable|string|max:1000',
            'phone' => 'sometimes|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'sometimes|string|max:500',
            'latitude' => 'sometimes|numeric|between:-90,90',
            'longitude' => 'sometimes|numeric|between:-180,180',
            'delivery_radius' => 'sometimes|numeric|min:0',
            'minimum_order' => 'sometimes|numeric|min:0',
            'delivery_fee' => 'sometimes|numeric|min:0',
            'service_charge_percentage' => 'sometimes|numeric|min:0|max:100',
            'tax_percentage' => 'sometimes|numeric|min:0|max:100',
            'opening_time' => 'nullable|date_format:H:i',
            'closing_time' => 'nullable|date_format:H:i',
            'status' => 'sometimes|in:pending,approved,suspended,rejected',
            'operational_status' => 'sometimes|in:open,closed,busy',
            'is_featured' => 'sometimes|boolean',
            'commission_percentage' => 'sometimes|numeric|min:0|max:100',
            'logo' => 'nullable|image|max:2048',
            'cover_image' => 'nullable|image|max:2048'
        ];
    }
}