<?php

namespace App\Listeners;

use App\Events\OrderStatusChanged;
use App\Services\DeliveryMatchingService;
use Illuminate\Support\Facades\Log;

class AssignDeliveryBoy
{
    public function __construct(private DeliveryMatchingService $matchingService)
    {
    }

    public function handle(OrderStatusChanged $event): void
    {
        if ($event->order->status === 'ready' && !$event->order->assigned_delivery_boy_id) {
            try {
                $deliveryBoy = $this->matchingService->findAndAssignDeliveryBoy($event->order);
                
                if ($deliveryBoy) {
                    Log::info("Order {$event->order->id} assigned to delivery boy {$deliveryBoy->id}");
                } else {
                    Log::warning("No delivery boy found for order {$event->order->id}");
                }
            } catch (\Exception $e) {
                Log::error("Failed to assign delivery boy for order {$event->order->id}: {$e->getMessage()}");
            }
        }
    }
}
