<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CategoryVariation extends Model
{
    protected $fillable = ['category_id', 'name', 'price'];

    protected $casts = [
        'price' => 'decimal:2',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}
