<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Delivery extends Model
{
    protected $fillable = [
        'order_id', 'delivery_boy_id', 'status', 'pickup_latitude', 'pickup_longitude',
        'pickup_address', 'delivery_latitude', 'delivery_longitude', 'delivery_address',
        'distance_km', 'estimated_time', 'actual_time', 'delivery_fee',
        'delivery_boy_earning', 'platform_commission', 'route_coordinates',
        'delivery_notes', 'rejection_reason', 'assigned_at', 'accepted_at',
        'picked_up_at', 'delivered_at'
    ];

    protected $casts = [
        'pickup_latitude' => 'decimal:7',
        'pickup_longitude' => 'decimal:7',
        'delivery_latitude' => 'decimal:7',
        'delivery_longitude' => 'decimal:7',
        'distance_km' => 'decimal:2',
        'delivery_fee' => 'decimal:2',
        'delivery_boy_earning' => 'decimal:2',
        'platform_commission' => 'decimal:2',
        'route_coordinates' => 'array',
        'assigned_at' => 'datetime',
        'accepted_at' => 'datetime',
        'picked_up_at' => 'datetime',
        'delivered_at' => 'datetime',
    ];

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public function deliveryBoy(): BelongsTo
    {
        return $this->belongsTo(DeliveryBoy::class);
    }
}
