<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DeliveryBoyRating extends Model
{
    use HasFactory;

    protected $fillable = [
        'delivery_boy_id', 'order_id', 'customer_id', 'rating', 'review',
        'delivery_time_rating', 'behavior_rating', 'food_condition_rating'
    ];

    protected $casts = [
        'rating' => 'integer',
        'delivery_time_rating' => 'integer',
        'behavior_rating' => 'integer',
        'food_condition_rating' => 'integer',
    ];

    public function deliveryBoy(): BelongsTo
    {
        return $this->belongsTo(DeliveryBoy::class);
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(User::class, 'customer_id');
    }
}
