<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DeliveryBoyVehicle extends Model
{
    use HasFactory;

    const TYPE_BIKE = 'bike';
    const TYPE_SCOOTER = 'scooter';
    const TYPE_BICYCLE = 'bicycle';
    const TYPE_CAR = 'car';
    const TYPE_VAN = 'van';

    protected $fillable = [
        'delivery_boy_id', 'vehicle_type', 'vehicle_make', 'vehicle_model',
        'vehicle_number', 'vehicle_color', 'registration_year',
        'insurance_number', 'insurance_expiry', 'vehicle_photo', 'is_active'
    ];

    protected $casts = [
        'insurance_expiry' => 'date',
        'is_active' => 'boolean',
    ];

    public function deliveryBoy(): BelongsTo
    {
        return $this->belongsTo(DeliveryBoy::class);
    }
}
