<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderFinancial extends Model
{
    protected $fillable = [
        'order_id',
        'customer_paid',
        'platform_commission',
        'restaurant_earning',
        'delivery_earning',
        'refund_amount',
        'settlement_status'
    ];

    protected $casts = [
        'customer_paid' => 'decimal:2',
        'platform_commission' => 'decimal:2',
        'restaurant_earning' => 'decimal:2',
        'delivery_earning' => 'decimal:2',
        'refund_amount' => 'decimal:2',
    ];

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public static function calculateFromOrder(Order $order): array
    {
        $customerPaid = $order->total;
        $platformCommissionRate = 0.15; // 15%
        $deliveryCommissionRate = 0.80; // 80% of delivery fee goes to delivery boy
        
        $platformCommission = $customerPaid * $platformCommissionRate;
        $deliveryEarning = $order->delivery_fee * $deliveryCommissionRate;
        $restaurantEarning = $customerPaid - $platformCommission - $deliveryEarning;
        
        return [
            'customer_paid' => $customerPaid,
            'platform_commission' => $platformCommission,
            'restaurant_earning' => $restaurantEarning,
            'delivery_earning' => $deliveryEarning,
            'refund_amount' => 0,
            'settlement_status' => 'pending'
        ];
    }
}