<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductVariation extends Model
{
    protected $fillable = ['product_id', 'category_variation_id', 'name', 'value', 'price', 'discount', 'is_available'];

    protected $casts = [
        'price' => 'decimal:2',
        'discount' => 'decimal:2',
        'is_available' => 'boolean',
    ];

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function categoryVariation(): BelongsTo
    {
        return $this->belongsTo(CategoryVariation::class);
    }
}
