<?php

namespace App\Policies;

use App\Models\User;
use App\Models\DeliveryBoy;

class DeliveryBoyPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->hasAnyRole(['super-admin', 'admin']);
    }

    public function view(User $user, DeliveryBoy $deliveryBoy): bool
    {
        // Super admin can view all
        if ($user->hasRole('super-admin')) {
            return true;
        }

        // Admin can view all (or restrict to their shop if needed)
        if ($user->hasRole('admin')) {
            return true;
        }

        // Delivery boy can view only own profile
        if ($user->hasRole('delivery-boy')) {
            return $deliveryBoy->user_id === $user->id;
        }

        return false;
    }

    public function create(User $user): bool
    {
        return $user->hasRole('super-admin');
    }

    public function update(User $user, DeliveryBoy $deliveryBoy): bool
    {
        // Super admin can update all
        if ($user->hasRole('super-admin')) {
            return true;
        }

        // Delivery boy can update own profile
        if ($user->hasRole('delivery-boy')) {
            return $deliveryBoy->user_id === $user->id;
        }

        return false;
    }

    public function delete(User $user, DeliveryBoy $deliveryBoy): bool
    {
        return $user->hasRole('super-admin');
    }

    public function block(User $user, DeliveryBoy $deliveryBoy): bool
    {
        return $user->hasAnyRole(['super-admin', 'admin']);
    }

    public function verify(User $user, DeliveryBoy $deliveryBoy): bool
    {
        return $user->hasRole('super-admin');
    }

    public function manageEarnings(User $user): bool
    {
        return $user->hasAnyRole(['super-admin', 'admin']);
    }

    public function managePayouts(User $user): bool
    {
        return $user->hasRole('super-admin');
    }
}
