<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Category;
use App\Models\Restaurant;

class ProductFactory extends Factory
{
    public function definition()
    {
        $name = fake()->words(3, true);
        $category = Category::query()->first() ?? Category::create([
            'name' => 'General',
            'slug' => 'general',
            'description' => null,
            'image' => null,
            'sort_order' => 1,
            'is_active' => true,
        ]);
        $restaurant = Restaurant::factory()->create();
        return [
            'restaurant_id' => $restaurant->id,
            'category_id' => $category->id,
            'name' => $name,
            'slug' => Str::slug($name) . '-' . Str::random(6),
            'description' => fake()->sentence(),
            'price' => fake()->numberBetween(500, 3000),
            'discount_price' => null,
            'discount_type' => null,
            'image' => 'default.jpg',
            'images' => [],
            'is_available' => true,
            'is_featured' => fake()->boolean(30),
            'is_vegetarian' => false,
            'is_spicy' => false,
            'preparation_time' => 15,
            'sort_order' => 0,
            'rating' => 0,
            'total_reviews' => 0,
            'total_orders' => 0,
        ];
    }
}
