<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('order_admin_actions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('admin_id')->constrained('users')->onDelete('cascade');
            $table->enum('action', ['force_cancel', 'reassign', 'refund', 'override_status', 'manual_delivery']);
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index(['order_id', 'created_at']);
            $table->index(['admin_id', 'action']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('order_admin_actions');
    }
};