<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('order_audit_trails', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('user_role');
            $table->enum('action_type', ['status_change', 'manual_override', 'refund', 'cancellation', 'assignment', 'flag_action']);
            $table->string('action_description');
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();
            $table->text('reason')->nullable();
            $table->string('ip_address')->nullable();
            $table->string('user_agent')->nullable();
            $table->timestamps();
            
            $table->index(['order_id', 'created_at']);
            $table->index(['user_id', 'action_type']);
            $table->index(['action_type', 'created_at']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('order_audit_trails');
    }
};