<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('order_financial_snapshots', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->decimal('customer_payment', 10, 2);
            $table->decimal('platform_commission', 10, 2);
            $table->decimal('restaurant_earning', 10, 2);
            $table->decimal('delivery_boy_earning', 10, 2);
            $table->decimal('refund_amount', 10, 2)->default(0);
            $table->enum('settlement_status', ['pending', 'processing', 'settled', 'failed'])->default('pending');
            $table->timestamp('snapshot_created_at');
            $table->boolean('is_immutable')->default(false);
            $table->timestamps();
            
            $table->unique('order_id');
            $table->index(['settlement_status', 'is_immutable']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('order_financial_snapshots');
    }
};