<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('delivery_rejections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('delivery_boy_id')->constrained('users')->onDelete('cascade');
            $table->enum('reason', ['too_far', 'busy', 'vehicle_issue', 'other'])->default('other');
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index(['delivery_boy_id', 'created_at']);
            $table->index(['order_id', 'created_at']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('delivery_rejections');
    }
};