<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->decimal('refund_amount', 10, 2)->default(0);
            $table->text('refund_reason')->nullable();
            $table->enum('refund_status', ['pending', 'processed', 'failed'])->nullable();
            $table->string('refunded_by')->nullable();
            $table->timestamp('refunded_at')->nullable();
            $table->string('cancelled_by')->nullable();
            
            $table->index(['refund_status', 'refunded_at']);
        });
    }

    public function down()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn([
                'refund_amount', 'refund_reason', 'refund_status', 
                'refunded_by', 'refunded_at', 'cancelled_by'
            ]);
        });
    }
};