<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('restaurants', function (Blueprint $table) {
            // Location fields
            if (!Schema::hasColumn('restaurants', 'latitude')) {
                $table->decimal('latitude', 10, 8)->nullable()->after('address');
            }
            if (!Schema::hasColumn('restaurants', 'longitude')) {
                $table->decimal('longitude', 11, 8)->nullable()->after('latitude');
            }
            
            // Commission rate
            if (!Schema::hasColumn('restaurants', 'commission_rate')) {
                $table->decimal('commission_rate', 5, 2)->default(0)->after('longitude');
            }
            
            // Subscription fields
            if (!Schema::hasColumn('restaurants', 'monthly_fee')) {
                $table->decimal('monthly_fee', 10, 2)->default(0)->after('commission_rate');
            }
            if (!Schema::hasColumn('restaurants', 'next_payment_date')) {
                $table->date('next_payment_date')->nullable()->after('monthly_fee');
            }
            if (!Schema::hasColumn('restaurants', 'last_payment_date')) {
                $table->date('last_payment_date')->nullable()->after('next_payment_date');
            }
            if (!Schema::hasColumn('restaurants', 'payment_status')) {
                $table->enum('payment_status', ['paid', 'pending', 'overdue'])->default('pending')->after('last_payment_date');
            }
        });
    }

    public function down(): void
    {
        Schema::table('restaurants', function (Blueprint $table) {
            $table->dropColumn([
                'latitude',
                'longitude',
                'commission_rate',
                'monthly_fee',
                'next_payment_date',
                'last_payment_date',
                'payment_status'
            ]);
        });
    }
};
