<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            $table->id();
            $table->string('log_type'); // delivery_boy, order, payment, etc.
            $table->string('action'); // created, updated, deleted, blocked, etc.
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->morphs('subject'); // The model being acted upon
            $table->json('properties')->nullable(); // Changed data
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();

            $table->index(['log_type', 'action']);
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};
