<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('restaurant_products', function (Blueprint $table) {
            if (!Schema::hasColumn('restaurant_products', 'min_order_quantity')) {
                $table->integer('min_order_quantity')->default(1)->after('stock_quantity');
            }
            if (!Schema::hasColumn('restaurant_products', 'available_from')) {
                $table->time('available_from')->nullable()->after('special_end_date');
            }
            if (!Schema::hasColumn('restaurant_products', 'available_until')) {
                $table->time('available_until')->nullable()->after('available_from');
            }
        });
    }

    public function down(): void
    {
        Schema::table('restaurant_products', function (Blueprint $table) {
            $table->dropColumn(['min_order_quantity', 'available_from', 'available_until']);
        });
    }
};
