<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('restaurants', function (Blueprint $table) {
            $table->decimal('minimum_order', 10, 2)->default(500)->after('address');
            $table->decimal('delivery_fee', 10, 2)->default(100)->after('minimum_order');
            $table->decimal('delivery_radius', 10, 2)->default(10)->after('delivery_fee');
        });
    }

    public function down(): void
    {
        Schema::table('restaurants', function (Blueprint $table) {
            $table->dropColumn(['minimum_order', 'delivery_fee', 'delivery_radius']);
        });
    }
};
