<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class DeliveryBoysSeeder extends Seeder
{
    public function run(): void
    {
        $deliveryBoys = [
            ['name' => 'Kasun Perera', 'phone' => '0771234567', 'email' => 'kasun@delivery.com', 'city' => 'Colombo'],
            ['name' => 'Nuwan Silva', 'phone' => '0772345678', 'email' => 'nuwan@delivery.com', 'city' => 'Colombo'],
            ['name' => 'Saman Fernando', 'phone' => '0773456789', 'email' => 'saman@delivery.com', 'city' => 'Kandy'],
            ['name' => 'Ruwan Jayasinghe', 'phone' => '0774567890', 'email' => 'ruwan@delivery.com', 'city' => 'Galle'],
            ['name' => 'Chamara Wickramasinghe', 'phone' => '0775678901', 'email' => 'chamara@delivery.com', 'city' => 'Colombo'],
            ['name' => 'Dilshan Rajapaksa', 'phone' => '0776789012', 'email' => 'dilshan@delivery.com', 'city' => 'Negombo'],
            ['name' => 'Tharindu Bandara', 'phone' => '0777890123', 'email' => 'tharindu@delivery.com', 'city' => 'Kandy'],
            ['name' => 'Lahiru Gamage', 'phone' => '0778901234', 'email' => 'lahiru@delivery.com', 'city' => 'Colombo'],
            ['name' => 'Dinesh Chandimal', 'phone' => '0779012345', 'email' => 'dinesh@delivery.com', 'city' => 'Gampaha'],
            ['name' => 'Asanka Priyantha', 'phone' => '0770123456', 'email' => 'asanka@delivery.com', 'city' => 'Colombo'],
        ];

        foreach ($deliveryBoys as $boy) {
            $user = User::firstOrCreate(
                ['email' => $boy['email']],
                [
                    'name' => $boy['name'],
                    'phone' => $boy['phone'],
                    'password' => Hash::make('password'),
                    'status' => 'active',
                ]
            );

            if (!$user->hasRole('delivery_boy')) {
                $user->assignRole('delivery_boy');
            }

            if (!DB::table('delivery_boys')->where('user_id', $user->id)->exists()) {
                DB::table('delivery_boys')->insert([
                    'user_id' => $user->id,
                    'full_name' => $boy['name'],
                    'phone' => $boy['phone'],
                    'email' => $boy['email'],
                    'city' => $boy['city'],
                    'status' => 'online',
                    'verification_status' => 'verified',
                    'is_available' => true,
                    'commission_rate' => 10.00,
                    'wallet_balance' => 0.00,
                    'rating' => rand(40, 50) / 10,
                    'total_ratings' => rand(10, 50),
                    'total_deliveries' => rand(50, 200),
                    'successful_deliveries' => rand(45, 195),
                    'joined_date' => now()->subDays(rand(30, 365)),
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
