<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Order;
use App\Models\OrderAdminAction;
use App\Models\User;

class OrderAdminActionSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Creating order admin actions...');
        
        $orders = Order::limit(20)->get();
        $admins = User::role(['super-admin', 'admin'])->get();
        $actions = ['force_cancel', 'reassign', 'refund', 'override_status'];
        
        foreach ($orders as $order) {
            // 30% chance of having admin action
            if (rand(1, 100) <= 30) {
                $admin = $admins->random();
                $action = $actions[array_rand($actions)];
                
                $notes = match($action) {
                    'force_cancel' => 'Order cancelled due to restaurant closure',
                    'reassign' => 'Delivery boy reassigned due to unavailability',
                    'refund' => 'Full refund processed for customer complaint',
                    'override_status' => 'Status manually updated by admin',
                };
                
                OrderAdminAction::create([
                    'order_id' => $order->id,
                    'admin_id' => $admin->id,
                    'action' => $action,
                    'notes' => $notes,
                    'created_at' => $order->created_at->addMinutes(rand(10, 60)),
                    'updated_at' => $order->created_at->addMinutes(rand(10, 60))
                ]);
            }
        }
        
        $this->command->info('Order admin actions created successfully!');
    }
}