<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Order;
use App\Models\OrderFlag;
use App\Services\OrderRiskDetectionService;

class RiskDetectionSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Running risk detection and creating sample flags...');
        
        // Run all risk detections
        $results = OrderRiskDetectionService::runAllDetections();
        
        // Create some additional sample flags for demonstration
        $orders = Order::limit(10)->get();
        
        foreach ($orders as $order) {
            // 30% chance of having a risk flag
            if (rand(1, 100) <= 30) {
                $flagTypes = ['late_delivery', 'payment_issue', 'customer_complaint'];
                $severities = ['low', 'medium', 'high', 'critical'];
                
                $type = $flagTypes[array_rand($flagTypes)];
                $severity = $severities[array_rand($severities)];
                
                $descriptions = [
                    'late_delivery' => 'Order delivered 45 minutes beyond estimated time',
                    'payment_issue' => 'Payment gateway reported transaction discrepancy',
                    'customer_complaint' => 'Customer reported food quality issues'
                ];
                
                OrderFlag::create([
                    'order_id' => $order->id,
                    'type' => $type,
                    'severity' => $severity,
                    'resolved' => rand(0, 1),
                    'description' => $descriptions[$type]
                ]);
            }
        }
        
        $totalFlags = collect($results)->except('detection_timestamp')->sum(function($data) {
            return is_array($data) ? count($data) : 0;
        });
        
        $this->command->info("Risk detection completed. {$totalFlags} issues detected and flagged.");
    }
}