<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Order;
use App\Models\Restaurant;
use App\Models\OrderAdminAction;
use App\Models\User;

class SuperAdminControlSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Creating Super Admin control demo data...');
        
        $superAdmin = User::role('super-admin')->first();
        $orders = Order::limit(20)->get();
        $restaurants = Restaurant::limit(5)->get();
        
        // Create some cancelled orders
        foreach ($orders->take(5) as $order) {
            $order->update([
                'status' => 'cancelled',
                'cancellation_reason' => 'Force cancelled by Super Admin for quality issues',
                'cancelled_by' => 'super_admin',
                'cancelled_at' => now()
            ]);
            
            OrderAdminAction::create([
                'order_id' => $order->id,
                'admin_id' => $superAdmin->id,
                'action' => 'force_cancel',
                'notes' => 'Quality control cancellation'
            ]);
        }
        
        // Create some refunded orders
        foreach ($orders->skip(5)->take(3) as $order) {
            $refundAmount = $order->total * 0.5; // 50% refund
            
            $order->update([
                'refund_amount' => $refundAmount,
                'refund_reason' => 'Customer complaint - partial refund processed',
                'refund_status' => 'processed',
                'refunded_by' => 'super_admin',
                'refunded_at' => now()
            ]);
            
            OrderAdminAction::create([
                'order_id' => $order->id,
                'admin_id' => $superAdmin->id,
                'action' => 'refund',
                'notes' => "Partial refund: Rs.{$refundAmount}"
            ]);
        }
        
        // Block some restaurants
        foreach ($restaurants->take(2) as $restaurant) {
            $restaurant->update([
                'is_blocked' => true,
                'blocked_reason' => 'Multiple customer complaints - temporary suspension',
                'blocked_by' => $superAdmin->id,
                'blocked_at' => now(),
                'blocked_until' => now()->addHours(24)
            ]);
        }
        
        $this->command->info('Super Admin control demo data created successfully!');
    }
}