<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // Create admin user
        $admin = User::firstOrCreate([
            'email' => 'admin@test.com'
        ], [
            'name' => 'Admin User',
            'password' => Hash::make('password'),
            'phone' => '1234567890',
            'email_verified_at' => now(),
        ]);
        $admin->assignRole('admin');
        if (!$admin->wallet) {
            $admin->wallet()->create(['balance' => 10000]);
        }

        // Create manager user
        $manager = User::firstOrCreate([
            'email' => 'manager@test.com'
        ], [
            'name' => 'Restaurant Manager',
            'password' => Hash::make('password'),
            'phone' => '1234567891',
            'email_verified_at' => now(),
        ]);
        $manager->assignRole('manager');
        if (!$manager->wallet) {
            $manager->wallet()->create(['balance' => 5000]);
        }

        // Create customer user
        $customer = User::firstOrCreate([
            'email' => 'customer@test.com'
        ], [
            'name' => 'Customer User',
            'password' => Hash::make('password'),
            'phone' => '1234567892',
            'email_verified_at' => now(),
        ]);
        $customer->assignRole('customer');
        if (!$customer->wallet) {
            $customer->wallet()->create(['balance' => 1000]);
        }

        // Create delivery boy user
        $deliveryBoy = User::firstOrCreate([
            'email' => 'delivery@test.com'
        ], [
            'name' => 'Delivery Boy',
            'password' => Hash::make('password'),
            'phone' => '1234567893',
            'email_verified_at' => now(),
        ]);
        $deliveryBoy->assignRole('delivery-boy');
        if (!$deliveryBoy->wallet) {
            $deliveryBoy->wallet()->create(['balance' => 500]);
        }
    }
}