import { ref } from 'vue';

const toasts = ref([]);
let id = 0;

export function useToast() {
  const show = (message, type = 'success', duration = 3000) => {
    const toast = { id: id++, message, type, duration };
    toasts.value.push(toast);
  };

  const removeToast = (toastId) => {
    toasts.value = toasts.value.filter(t => t.id !== toastId);
  };

  const success = (message, duration) => show(message, 'success', duration);
  const error = (message, duration) => show(message, 'error', duration);
  const info = (message, duration) => show(message, 'info', duration);
  const warning = (message, duration) => show(message, 'warning', duration);

  return { toasts, success, error, info, warning, removeToast };
}
