import axios from 'axios'

class AdminApiService {
  constructor() {
    this.baseURL = '/api/admin'
  }

  // Dashboard
  async getDashboard() {
    const response = await axios.get(`${this.baseURL}/dashboard`)
    return response.data
  }

  async getAnalytics(days = 7) {
    const response = await axios.get(`${this.baseURL}/analytics?days=${days}`)
    return response.data
  }

  async getSystemHealth() {
    const response = await axios.get(`${this.baseURL}/system-health`)
    return response.data
  }

  // Restaurants
  async getPendingRestaurants() {
    const response = await axios.get(`${this.baseURL}/restaurants/pending`)
    return response.data
  }

  async approveRestaurant(id) {
    const response = await axios.post(`${this.baseURL}/restaurants/${id}/approve`)
    return response.data
  }

  async suspendRestaurant(id) {
    const response = await axios.post(`${this.baseURL}/restaurants/${id}/suspend`)
    return response.data
  }

  // Orders
  async exportOrders(filters = {}) {
    const params = new URLSearchParams(filters)
    const response = await axios.get(`${this.baseURL}/orders/export?${params}`, {
      responseType: 'blob'
    })
    return response
  }

  // Earnings
  async getEarningsReport(from = null, to = null) {
    const params = new URLSearchParams()
    if (from) params.append('from', from)
    if (to) params.append('to', to)
    
    const response = await axios.get(`${this.baseURL}/earnings?${params}`)
    return response.data
  }
}

export default new AdminApiService()