import { defineStore } from 'pinia';
import api from '../services/api';

export const useCartStore = defineStore('cart', {
  state: () => ({
    count: 0,
  }),

  actions: {
    async loadCount() {
      try {
        const response = await api.get('/cart');
        const items = response.data.data || response.data || [];
        this.count = items.length;
      } catch (error) {
        this.count = 0;
      }
    },

    async addItem(productId, quantity = 1) {
      await api.post('/cart', { product_id: productId, quantity });
      await this.loadCount();
    },

    clearCount() {
      this.count = 0;
    },
  },
});
