<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delivery Boy - New Orders</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; padding: 20px; }
        h1 { font-size: 32px; margin-bottom: 20px; }
        .loading { text-align: center; padding: 60px; }
        .empty { text-align: center; padding: 60px; color: #999; }
        .order-card { background: white; border-radius: 12px; padding: 20px; margin-bottom: 20px; box-shadow: 0 4px 12px rgba(255,107,53,0.3); border: 3px solid #ff6b35; animation: pulse 2s infinite; }
        @keyframes pulse { 0%, 100% { transform: scale(1); } 50% { transform: scale(1.02); } }
        .order-header { display: flex; justify-content: space-between; margin-bottom: 15px; }
        .order-number { font-size: 24px; font-weight: bold; color: #ff6b35; }
        .order-amount { font-size: 24px; font-weight: bold; color: #000; }
        .customer-info { background: #f9f9f9; padding: 15px; border-radius: 8px; margin-bottom: 15px; }
        .customer-name { font-weight: bold; margin-bottom: 5px; }
        .btn-accept { width: 100%; padding: 15px; background: #10b981; color: white; border: none; border-radius: 8px; font-size: 18px; font-weight: bold; cursor: pointer; }
        .btn-accept:hover { background: #059669; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔔 New Orders</h1>
        <div id="orders"></div>
    </div>

    <audio id="notificationSound" preload="auto">
        <source src="data:audio/wav;base64,UklGRnoGAABXQVZFZm10IBAAAAABAAEAQB8AAEAfAAABAAgAZGF0YQoGAACBhYqFbF1fdJivrJBhNjVgodDbq2EcBj+a2/LDciUFLIHO8tiJNwgZaLvt559NEAxQp+PwtmMcBjiR1/LMeSwFJHfH8N2QQAoUXrTp66hVFApGn+DyvmwhBSuBzvLZiTYIGGS57OihUBELTKXh8bllHAU2jdXvzn0pBSh+zPDajzsKElyx6OyrWBUIQ5zd8sFuJAUuhM/z24k2CBdju+zooVARC0yl4fG5ZRwFNo3V7859KQUofszw2o87ChJcsejtq1gVCEOc3fLBbiQFLoTP89uJNggXY7vs6KFQEQtMpeHxuWUcBTaN1e/OfSkFKH7M8NqPOwsSXLHo7atYFQhDnN3ywW4kBS6Ez/PbiTYIF2O77OihUBELTKXh8bllHAU2jdXvzn0pBSh+zPDajzsKElyx6O2rWBUIQ5zd8sFuJAUuhM/z24k2CBdju+zooVARC0yl4fG5ZRwFNo3V7859KQUofszw2o87ChJcsejtq1gVCEOc3fLBbiQFLoTP89uJNggXY7vs6KFQEQtMpeHxuWUcBTaN1e/OfSkFKH7M8NqPOwsSXLHo7atYFQhDnN3ywW4kBS6Ez/PbiTYIF2O77OihUBELTKXh8bllHAU2jdXvzn0pBSh+zPDajzsKElyx6O2rWBUIQ5zd8sFuJAUuhM/z24k2CBdju+zooVARC0yl4fG5ZRwFNo3V7859KQUofszw2o87ChJcsejtq1gVCEOc3fLBbiQFLoTP89uJNggXY7vs6KFQEQtMpeHxuWUcBTaN1e/OfSkFKH7M8NqPOwsSXLHo7atYFQhDnN3ywW4kBS6Ez/PbiTYIF2O77OihUBELTKXh8bllHAU2jdXvzn0pBSh+zPDajzsKElyx6O2rWBUIQ5zd8sFuJAUuhM/z24k2CBdju+zooVARC0yl4fG5ZRwFNo3V7859KQUofszw2o87ChJcsejtq1gVCEOc3fLBbiQFLoTP89uJNggXY7vs6KFQEQtMpeHxuWUcBTaN1e/OfSkFKH7M8NqPOwsSXLHo7atYFQhDnN3ywW4kBS6Ez/PbiTYIF2O77OihUBELTKXh8bllHAU2jdXvzn0pBSh+zPDajzsKElyx6O2rWBUIQ5zd8sFuJAUuhM/z24k2CBdju+zooVARC0yl4fG5ZRwFNo3V7859KQUofszw2o87ChJcsejtq1gVCEOc3fLBbiQFLoTP89uJNggXY7vs6KFQEQtMpeHxuWUcBTaN1e/OfSkFKH7M8NqPOwsSXLHo7atYFQhDnN3ywW4kBS6Ez/PbiTYIF2O77OihUBELTKXh8bllHAU2jdXvzn0pBSh+zPDajzsKElyx6O2rWBUIQ5zd8sFuJAUuhM/z24k2CBdju+zooVARC0yl4fG5ZRwFNo3V7859KQUofszw2o87ChJcsejtq1gVCEOc3fLBbiQFLoTP89uJNggXY7vs6KFQEQtMpeHxuWUcBTaN1e/OfSkFKH7M8NqPOwsSXLHo7atYFQhDnN3ywW4kBS6Ez/PbiTYIF2O77OihUBELTKXh8bllHAU2jdXvzn0pBSh+zPDajzsKElyx6O2rWBUIQ5zd8sFuJAUuhM/z24k2CBdju+zooVARC0yl4fG5ZRwFNo3V7859KQUofszw2o87ChJcsejtq1gVCEOc3fLBbiQFLoTP89uJNggXY7vs6KFQEQtMpeHxuWUcBTaN1e/OfSkFKH7M8NqPOwsSXLHo7atYFQ==" type="audio/wav">
    </audio>

    <script>
        let token = localStorage.getItem('delivery_token');
        let previousCount = 0;

        async function loadOrders() {
            try {
                const res = await fetch('/api/delivery-boy/assignments/pending', {
                    headers: { 
                        'Authorization': 'Bearer ' + token,
                        'Accept': 'application/json'
                    }
                });
                
                if (!res.ok) return;
                
                const data = await res.json();
                const assignments = data.data || [];
                
                if (assignments.length > previousCount && previousCount > 0) {
                    document.getElementById('notificationSound').play();
                }
                previousCount = assignments.length;
                
                const container = document.getElementById('orders');
                
                if (assignments.length === 0) {
                    container.innerHTML = '<div class="empty"><div style="font-size:60px">📭</div><h3>No new orders</h3><p>Waiting for orders...</p></div>';
                    return;
                }
                
                container.innerHTML = assignments.map(a => `
                    <div class="order-card">
                        <div class="order-header">
                            <div class="order-number">#${a.order.order_number}</div>
                            <div class="order-amount">Rs ${a.order.total}</div>
                        </div>
                        <div style="background:#fff3cd;padding:10px;border-radius:8px;margin-bottom:15px;">
                            <div style="font-weight:bold;color:#856404">⚡ Distance: ${a.distance_km} km | Score: ${Math.round(a.score)}</div>
                            <div style="font-size:12px;color:#856404;margin-top:5px">Rank: #${a.rank} | Notified: ${new Date(a.notified_at).toLocaleTimeString()}</div>
                        </div>
                        <div class="customer-info">
                            <div class="customer-name">${a.order.user?.name || 'Customer'}</div>
                            <div>${a.order.delivery_address}</div>
                            <div style="margin-top:5px;color:#666">Delivery: Rs ${a.order.delivery_fee}</div>
                        </div>
                        <button class="btn-accept" onclick="acceptAssignment(${a.id})">✅ Accept Order</button>
                        <button style="width:100%;padding:10px;background:#ef4444;color:white;border:none;border-radius:8px;font-size:14px;font-weight:bold;cursor:pointer;margin-top:10px;" onclick="rejectAssignment(${a.id})">❌ Reject</button>
                    </div>
                `).join('');
            } catch (e) {
                console.error(e);
            }
        }

        async function acceptAssignment(assignmentId) {
            try {
                const res = await fetch('/api/delivery-boy/assignments/' + assignmentId + '/accept', {
                    method: 'POST',
                    headers: { 
                        'Authorization': 'Bearer ' + token,
                        'Accept': 'application/json'
                    }
                });
                
                if (res.ok) {
                    alert('Order accepted!');
                    loadOrders();
                } else {
                    alert('Order no longer available');
                    loadOrders();
                }
            } catch (e) {
                alert('Failed to accept order');
            }
        }

        async function rejectAssignment(assignmentId) {
            const reason = prompt('Reason for rejection:');
            if (!reason) return;
            
            try {
                const res = await fetch('/api/delivery-boy/assignments/' + assignmentId + '/reject', {
                    method: 'POST',
                    headers: { 
                        'Authorization': 'Bearer ' + token,
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ reason })
                });
                
                if (res.ok) {
                    alert('Order rejected');
                    loadOrders();
                }
            } catch (e) {
                alert('Failed to reject order');
            }
        }

        loadOrders();
        setInterval(loadOrders, 5000);
    </script>
</body>
</html>
