<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\RestaurantController;
use App\Http\Controllers\API\RestaurantMenuController;
use App\Http\Controllers\API\ProductController;
use App\Http\Controllers\API\CartController;
use App\Http\Controllers\API\OrderController;
use App\Http\Controllers\API\AdminController;
use App\Http\Controllers\API\DeliveryController;
use App\Http\Controllers\API\TestSetupController;
use App\Http\Controllers\API\DashboardTestController;
use App\Http\Controllers\API\SimpleTestController;
use App\Http\Controllers\API\DeliveryBoyController;
use App\Http\Controllers\API\PaymentController;
use App\Http\Controllers\API\ReviewController;
use App\Http\Controllers\API\PromoCodeController;
use App\Http\Controllers\API\DistanceController;
use App\Http\Controllers\API\UserController;

// Admin Controllers
use App\Http\Controllers\API\Admin\AdminAuthController;
use App\Http\Controllers\API\Admin\RestaurantManagementController;
use App\Http\Controllers\API\Admin\ProductManagementController;
use App\Http\Controllers\API\Admin\GlobalProductController;
use App\Http\Controllers\API\Admin\CategoryManagementController;
use App\Http\Controllers\API\Admin\ProductController as AdminProductController;
use App\Http\Controllers\API\Manager\ProductController as ManagerProductController;
use App\Http\Controllers\API\Manager\CategoryController as ManagerCategoryController;
use App\Http\Controllers\API\Manager\AddonController as ManagerAddonController;
use App\Http\Controllers\API\Manager\RestaurantProductController;
use App\Http\Controllers\API\Cashier\ProductController as CashierProductController;
use App\Http\Controllers\API\Admin\DeliveryBoyController as AdminDeliveryBoyController;
use App\Http\Controllers\API\DeliveryBoy\LocationController;
use App\Http\Controllers\API\Admin\OrderManagementController;
use App\Http\Controllers\API\Admin\PaymentCommissionManagementController;
use App\Http\Controllers\API\Admin\UserManagementController;
use App\Http\Controllers\API\Admin\NotificationController;
use App\Http\Controllers\API\Admin\ProfileController;
use App\Http\Controllers\API\Admin\DashboardAnalyticsController;
use App\Http\Controllers\API\Admin\SettingsManagementController;
use App\Http\Controllers\API\Admin\SuperAdminDashboardController;
use App\Http\Controllers\API\Admin\AdvancedDashboardController;
use App\Http\Controllers\API\Admin\RiskManagementController;
use App\Http\Controllers\API\SuperAdmin\OrderControlController;
use App\Http\Controllers\API\AdminTestController;

// Test routes for admin functionality
Route::get('/test/create-admin', [AdminTestController::class, 'createTestAdmin']);
Route::get('/test/dashboard-data', [AdminTestController::class, 'testDashboardData']);

// Public routes
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('/reset-password', [AuthController::class, 'resetPassword']);

// Admin login route
Route::post('/admin/login', [AdminAuthController::class, 'login']);

// Public restaurant and product routes
Route::get('/restaurants', [RestaurantController::class, 'index']);
Route::get('/restaurants/{id}', [RestaurantController::class, 'show']);
Route::post('/distance/calculate', [DistanceController::class, 'calculate']);
Route::get('/restaurants/{id}/categories', [RestaurantMenuController::class, 'getCategories']);
Route::get('/restaurants/{id}/products', [RestaurantMenuController::class, 'getProducts']);
Route::get('/products', [ProductController::class, 'index']);
Route::get('/products/{id}', [ProductController::class, 'show']);
Route::get('/products/{id}/variants', [RestaurantMenuController::class, 'getProductVariants']);
Route::get('/products/{id}/addons', [RestaurantMenuController::class, 'getProductAddons']);
Route::get('/categories', [App\Http\Controllers\API\Admin\CategoryManagementController::class, 'index']);

// Public delivery boy page
Route::get('/delivery-boy', function () {
    return view('delivery-boy-mobile');
});

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    // Auth
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);

    // User Profile
    Route::get('/user/profile', [UserController::class, 'profile']);
    Route::put('/user/profile', [UserController::class, 'updateProfile']);
    Route::post('/user/change-password', [UserController::class, 'changePassword']);
    Route::get('/user/stats', [UserController::class, 'stats']);
    Route::post('/user/avatar', [UserController::class, 'uploadAvatar']);

    // Test setup routes
    Route::get('/test/setup-users', [SimpleTestController::class, 'setupTestUsers']);
    Route::middleware('auth:sanctum')->get('/test/auth', [SimpleTestController::class, 'testAuth']);
    Route::middleware('auth:sanctum')->get('/test/admin-dashboard', [DashboardTestController::class, 'testAdminDashboard']);
    Route::middleware('auth:sanctum')->get('/test/manager-dashboard', [DashboardTestController::class, 'testManagerDashboard']);
    Route::middleware('auth:sanctum')->get('/test/delivery-dashboard', [DashboardTestController::class, 'testDeliveryBoyDashboard']);

    // Restaurants
    Route::middleware('role:manager,admin,super-admin')->group(function () {
        Route::post('/restaurants', [RestaurantController::class, 'store']);
    });
    
    // Admin can update and delete restaurants
    Route::middleware('role:admin,super-admin,manager')->group(function () {
        Route::put('/restaurants/{id}', [RestaurantController::class, 'update']);
        Route::delete('/restaurants/{id}', [RestaurantController::class, 'destroy']);
    });

    // Manager & Admin Products
    Route::middleware('role:manager,admin')->prefix('manager')->group(function () {
        // Dashboard
        Route::get('/dashboard-data', [App\Http\Controllers\API\Manager\DashboardController::class, 'index']);
        Route::get('/dashboard-stats', [App\Http\Controllers\API\Manager\DashboardController::class, 'getDashboardStats']);
        Route::get('/revenue-chart', [App\Http\Controllers\API\Manager\DashboardController::class, 'getRevenueChart']);
        Route::get('/map-deliveries', [App\Http\Controllers\API\Manager\DashboardController::class, 'getMapDeliveries']);
        Route::get('/available-delivery-boys', [App\Http\Controllers\API\Manager\DashboardController::class, 'getAvailableDeliveryBoys']);
        Route::post('/orders/{order}/assign-delivery-boy', [App\Http\Controllers\API\Manager\DashboardController::class, 'assignDeliveryBoy']);
        
        // Restaurant
        Route::get('/restaurant', [App\Http\Controllers\API\Manager\RestaurantController::class, 'show']);
        Route::put('/restaurant', [App\Http\Controllers\API\Manager\RestaurantController::class, 'update']);
        
        // Delivery Boys
        Route::get('/delivery-boys', [App\Http\Controllers\API\Manager\DeliveryBoyController::class, 'index']);
        Route::post('/delivery-boys', [App\Http\Controllers\API\Manager\DeliveryBoyController::class, 'store']);
        Route::get('/delivery-boys/{deliveryBoy}', [App\Http\Controllers\API\Manager\DeliveryBoyController::class, 'show']);
        
        // Orders
        Route::get('/orders', [App\Http\Controllers\API\Manager\OrderController::class, 'index']);
        Route::get('/orders/{id}', [App\Http\Controllers\API\Manager\OrderController::class, 'show']);
        Route::put('/orders/{id}/status', [App\Http\Controllers\API\Manager\OrderController::class, 'updateStatus']);
        Route::post('/orders/{id}/notify-delivery-boys', [App\Http\Controllers\API\Manager\OrderController::class, 'notifyDeliveryBoys']);
        Route::get('/order-history', [App\Http\Controllers\API\Manager\OrderController::class, 'history']);
        Route::get('/cancelled-orders', [App\Http\Controllers\API\Manager\OrderController::class, 'cancelledOrders']);
        
        // Products
        Route::get('/products', [ManagerProductController::class, 'index']);
        Route::get('/products/trashed', [ManagerProductController::class, 'trashed']);
        Route::get('/products/system-images', [ManagerProductController::class, 'getSystemImages']);
        Route::post('/products/upload-image', [ManagerProductController::class, 'uploadImage']);
        Route::post('/products', [ManagerProductController::class, 'store']);
        Route::get('/products/{id}', [ManagerProductController::class, 'show']);
        Route::put('/products/{id}', [ManagerProductController::class, 'update']);
        Route::post('/products/{id}/availability', [ManagerProductController::class, 'toggleAvailability']);
        Route::post('/products/{id}/restore', [ManagerProductController::class, 'restore']);
        Route::post('/products/{productId}/variations/{variationId}/availability', [ManagerProductController::class, 'toggleVariationAvailability']);
        Route::post('/products/{productId}/addons/{addonId}/availability', [ManagerProductController::class, 'toggleAddonAvailability']);
        Route::delete('/products/{id}', [ManagerProductController::class, 'destroy']);
        
        // Categories
        Route::get('/categories', [ManagerCategoryController::class, 'index']);
        Route::get('/categories/{category}/variations', [App\Http\Controllers\API\Admin\CategoryManagementController::class, 'getVariations']);
        Route::get('/categories/{category}/addons', [App\Http\Controllers\API\Admin\CategoryManagementController::class, 'getAddons']);
        Route::post('/categories', [ManagerCategoryController::class, 'store']);
        Route::put('/categories/{id}', [ManagerCategoryController::class, 'update']);
        Route::delete('/categories/{id}', [ManagerCategoryController::class, 'destroy']);
        
        // Add-ons
        Route::get('/addons', [ManagerAddonController::class, 'index']);
        Route::post('/addons', [ManagerAddonController::class, 'store']);
        
        // Restaurant Products (Add products from global catalog)
        Route::post('/restaurant-products', [RestaurantProductController::class, 'store']);
        Route::put('/restaurant-products/{id}', [RestaurantProductController::class, 'update']);
        Route::delete('/restaurant-products/{id}', [RestaurantProductController::class, 'destroy']);
        
        // Orders
        Route::get('/orders', [App\Http\Controllers\API\Manager\OrderController::class, 'index']);
        Route::get('/orders/{id}', [App\Http\Controllers\API\Manager\OrderController::class, 'show']);
    });

    // Cashier Products
    Route::middleware('role:cashier')->prefix('cashier/products')->group(function () {
        Route::post('/{id}/toggle-availability', [CashierProductController::class, 'toggleAvailability']);
        Route::post('/{id}/update-stock', [CashierProductController::class, 'updateStock']);
    });

    // Cart
    Route::get('/cart', [CartController::class, 'index']);
    Route::post('/cart', [CartController::class, 'store']);
    Route::put('/cart/{id}', [CartController::class, 'update']);
    Route::delete('/cart/{id}', [CartController::class, 'destroy']);
    Route::delete('/cart', [CartController::class, 'clear']);

    // Orders
    Route::get('/orders', [OrderController::class, 'index']);
    Route::post('/orders', [OrderController::class, 'store']);
    Route::get('/orders/{id}', [OrderController::class, 'show']);
    Route::post('/orders/{id}/rate', [OrderController::class, 'rate']);
    Route::get('/orders/{order}/track-delivery', [App\Http\Controllers\API\Customer\DeliveryTrackingController::class, 'trackOrder']);
    Route::post('/orders/{order}/rate-delivery', [App\Http\Controllers\API\Customer\DeliveryTrackingController::class, 'rateDeliveryBoy']);
    Route::middleware('role:cashier,manager,admin,super-admin')->group(function () {
        Route::put('/orders/{id}/status', [OrderController::class, 'updateStatus']);
    });
    Route::post('/orders/{id}/cancel', [OrderController::class, 'cancel']);
    Route::get('/orders/{id}/invoice', [OrderController::class, 'invoice']);

    // Admin
    Route::middleware('role:admin,super-admin')->group(function () {
        Route::get('/admin/dashboard', [AdminController::class, 'dashboard']);
        Route::get('/admin/analytics', [AdminController::class, 'getAnalytics']);
        Route::get('/admin/system-health', [AdminController::class, 'getSystemHealth']);
        Route::get('/admin/restaurants/pending', [AdminController::class, 'pendingRestaurants']);
        Route::post('/admin/restaurants/{id}/approve', [AdminController::class, 'approveRestaurant']);
        Route::post('/admin/restaurants/{id}/suspend', [AdminController::class, 'suspendRestaurant']);
        Route::get('/admin/orders/export', [AdminController::class, 'exportOrders']);
        Route::get('/admin/earnings', [AdminController::class, 'earningsReport']);
    });

    // Manager Dashboard
    Route::middleware('role:manager')->group(function () {
        Route::get('/manager/dashboard', [AdminController::class, 'managerDashboard']);
    });

    // Delivery Boy
    Route::middleware('role:delivery-boy,delivery_boy')->prefix('delivery-boy')->group(function () {
        Route::get('/dashboard', [DeliveryBoyController::class, 'dashboard']);
        Route::post('/status', [DeliveryBoyController::class, 'updateStatus']);
        Route::get('/available', [DeliveryBoyController::class, 'availableDeliveries']);
        Route::get('/my-deliveries', [DeliveryBoyController::class, 'myDeliveries']);
        Route::get('/earnings', [DeliveryBoyController::class, 'earnings']);
        Route::post('/deliveries/{id}/reject', [DeliveryController::class, 'rejectDelivery']);
        
        // Assignment
        Route::get('/assignments/pending', [App\Http\Controllers\API\DeliveryBoy\AssignmentController::class, 'pending']);
        Route::post('/assignments/{assignment}/accept', [App\Http\Controllers\API\DeliveryBoy\AssignmentController::class, 'accept']);
        Route::post('/assignments/{assignment}/reject', [App\Http\Controllers\API\DeliveryBoy\AssignmentController::class, 'reject']);
        
        // New delivery boy API routes for Flutter app
        Route::get('/orders/available', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'availableOrders']);
        Route::post('/orders/{orderId}/accept', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'acceptOrder']);
        Route::post('/orders/{orderId}/reject', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'rejectOrder']);
        Route::get('/orders/my-orders', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'myOrders']);
        Route::post('/location/update', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'updateLocation']);
        Route::post('/toggle-status', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'toggleStatus']);
        Route::put('/deliveries/{deliveryId}/status', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'updateDeliveryStatus']);
        Route::get('/earnings/summary', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'earnings']);
        Route::get('/earnings/details', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'earningsDetails']);
        Route::get('/notifications', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'notifications']);
        Route::put('/notifications/{notificationId}/viewed', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'markNotificationViewed']);
        Route::get('/heatmap-data', [App\Http\Controllers\API\DeliveryBoy\DeliveryBoyController::class, 'getHeatmapData']);
        
        // Location tracking
        Route::post('/location', [LocationController::class, 'update']);
    });

    // Location tracking (public for customers)
    Route::get('/deliveries/{delivery}/track', [LocationController::class, 'trackDelivery']);
    
    // Nearby delivery boys (admin only)
    Route::middleware('role:admin,super-admin')->group(function () {
        Route::get('/delivery-boys/nearby', [LocationController::class, 'nearby']);
    });

    // Payment
    Route::post('/orders/{id}/payment', [PaymentController::class, 'processPayment']);
    Route::middleware('role:admin,cashier')->group(function () {
        Route::post('/orders/{id}/refund', [PaymentController::class, 'refund']);
    });
    Route::get('/wallet/balance', [PaymentController::class, 'walletBalance']);
    Route::get('/wallet/transactions', [PaymentController::class, 'walletTransactions']);
    Route::post('/wallet/add-funds', [PaymentController::class, 'addFunds']);

    // Delivery
    Route::middleware('role:admin,manager')->group(function () {
        Route::post('/orders/{id}/assign-delivery', [DeliveryController::class, 'assignDelivery']);
    });
    Route::post('/deliveries/{id}/accept', [DeliveryController::class, 'acceptDelivery']);
    Route::put('/deliveries/{id}/status', [DeliveryController::class, 'updateStatus']);
    Route::get('/orders/{id}/track', [DeliveryController::class, 'trackDelivery']);

    // Reviews
    Route::post('/reviews', [ReviewController::class, 'store']);
    Route::get('/reviews', [ReviewController::class, 'index']);

    // Promo Codes
    Route::post('/promo-codes/validate', [PromoCodeController::class, 'validateCode']);
    Route::post('/promo-codes/apply', [PromoCodeController::class, 'apply']);
});

// Super Admin Routes - Only for super-admin role
Route::middleware(['auth:sanctum', 'role:super-admin'])->prefix('super-admin')->group(function () {
    
    // Dashboard
    Route::get('/dashboard', [SuperAdminDashboardController::class, 'index']);
    Route::get('/dashboard/advanced-stats', [AdvancedDashboardController::class, 'getAdvancedStats']);
    
    // Restaurants
    Route::get('/restaurants', [RestaurantManagementController::class, 'index']);
    Route::post('/restaurants', [RestaurantManagementController::class, 'store']);
    Route::get('/restaurants/{restaurant}', [RestaurantManagementController::class, 'show']);
    Route::put('/restaurants/{restaurant}', [RestaurantManagementController::class, 'update']);
    Route::delete('/restaurants/{restaurant}', [RestaurantManagementController::class, 'destroy']);
    Route::post('/restaurants/{restaurant}/approve', [RestaurantManagementController::class, 'approve']);
    Route::post('/restaurants/{restaurant}/suspend', [RestaurantManagementController::class, 'suspend']);
    
    // Delivery Boys
    Route::get('/delivery-boys', [AdminDeliveryBoyController::class, 'index']);
    Route::post('/delivery-boys', [AdminDeliveryBoyController::class, 'store']);
    Route::get('/delivery-boys/{deliveryBoy}', [AdminDeliveryBoyController::class, 'show']);
    Route::put('/delivery-boys/{deliveryBoy}', [AdminDeliveryBoyController::class, 'update']);
    Route::delete('/delivery-boys/{deliveryBoy}', [AdminDeliveryBoyController::class, 'destroy']);
    Route::post('/delivery-boys/{deliveryBoy}/block', [AdminDeliveryBoyController::class, 'block']);
    Route::post('/delivery-boys/{deliveryBoy}/verify-documents', [AdminDeliveryBoyController::class, 'verifyDocuments']);
    
    // Delivery Boy Vehicles
    Route::post('/delivery-boys/{deliveryBoy}/vehicles', [AdminDeliveryBoyController::class, 'addVehicle']);
    Route::put('/delivery-boys/{deliveryBoy}/vehicles/{vehicle}', [AdminDeliveryBoyController::class, 'updateVehicle']);
    Route::delete('/delivery-boys/{deliveryBoy}/vehicles/{vehicle}', [AdminDeliveryBoyController::class, 'deleteVehicle']);
    
    // Orders
    Route::get('/orders', [OrderManagementController::class, 'index']);
    Route::get('/orders/{order}', [OrderManagementController::class, 'show']);
    Route::put('/orders/{order}/status', [OrderManagementController::class, 'updateStatus']);
    Route::post('/orders/{order}/assign-delivery-boy', [OrderManagementController::class, 'assignDeliveryBoy']);
    
    // Super Admin Order Controls
    Route::post('/orders/{order}/force-cancel', [OrderControlController::class, 'forceCancel']);
    Route::post('/orders/{order}/reassign-delivery', [OrderControlController::class, 'reassignDeliveryBoy']);
    Route::post('/orders/{order}/manual-refund', [OrderControlController::class, 'processRefund']);
    Route::get('/orders/{order}/available-actions', [OrderControlController::class, 'getOrderActions']);
    Route::get('/orders/{order}/available-delivery-boys', [OrderControlController::class, 'getAvailableDeliveryBoys']);
    Route::post('/orders/bulk-actions', [OrderControlController::class, 'bulkActions']);
    
    // Restaurant Controls
    Route::post('/restaurants/{restaurant}/block', [OrderControlController::class, 'blockRestaurant']);
    Route::post('/restaurants/{restaurant}/unblock', [OrderControlController::class, 'unblockRestaurant']);
    Route::get('/restaurants/blocked', [OrderControlController::class, 'getBlockedRestaurants']);
    
    // Earnings
    Route::get('/earnings', [PaymentCommissionManagementController::class, 'financialReport']);
    Route::get('/payouts', [PaymentCommissionManagementController::class, 'payouts']);
    Route::post('/payouts/{payout}/process', [PaymentCommissionManagementController::class, 'processPayout']);
    
    // Users
    Route::get('/users', [UserManagementController::class, 'index']);
    Route::post('/users', [UserManagementController::class, 'store']);
    Route::get('/users/{user}', [UserManagementController::class, 'show']);
    Route::put('/users/{user}', [UserManagementController::class, 'update']);
    Route::post('/users/{user}/block', [UserManagementController::class, 'block']);
    Route::post('/users/{user}/unblock', [UserManagementController::class, 'unblock']);
    
    // Settings
    Route::get('/settings', [SettingsManagementController::class, 'index']);
    Route::put('/settings/{setting}', [SettingsManagementController::class, 'update']);
    Route::post('/settings/bulk-update', [SettingsManagementController::class, 'bulkUpdate']);
});

// Admin API Routes - For admin and super-admin
Route::middleware(['auth:sanctum', 'role:admin,super-admin'])->prefix('admin')->group(function () {
    
    // Admin auth routes
    Route::post('/logout', [AdminAuthController::class, 'logout']);
    Route::get('/user', [AdminAuthController::class, 'user']);
    
    // Dashboard
    Route::get('/dashboard', [SuperAdminDashboardController::class, 'index']);
    
    // Dashboard Analytics
    Route::get('/dashboard/analytics', [DashboardAnalyticsController::class, 'index']);
    Route::get('/dashboard/revenue-chart', [DashboardAnalyticsController::class, 'revenueChart']);
    Route::get('/dashboard/order-chart', [DashboardAnalyticsController::class, 'orderChart']);
    
    // Notifications
    Route::get('/notifications', [NotificationController::class, 'index']);
    Route::post('/notifications/mark-all-read', [NotificationController::class, 'markAllRead']);
    
    // Profile
    Route::get('/profile', [ProfileController::class, 'show']);
    Route::put('/profile', [ProfileController::class, 'update']);
    Route::post('/profile/photo', [ProfileController::class, 'updatePhoto']);
    Route::post('/profile/password', [ProfileController::class, 'updatePassword']);
    
    // Restaurant Management
    Route::get('/restaurants', [RestaurantManagementController::class, 'index']);
    Route::post('/restaurants', [RestaurantManagementController::class, 'store']);
    Route::get('/restaurants/{restaurant}', [RestaurantManagementController::class, 'show']);
    Route::put('/restaurants/{restaurant}', [RestaurantManagementController::class, 'update']);
    Route::delete('/restaurants/{restaurant}', [RestaurantManagementController::class, 'destroy']);
    Route::get('/restaurants/{restaurant}/analytics', [RestaurantManagementController::class, 'analytics']);
    Route::get('/restaurants/{restaurant}/orders', [RestaurantManagementController::class, 'orders']);
    
    // Product Management
    Route::get('/products/dashboard-stats', [ProductManagementController::class, 'getDashboardStats']);
    Route::get('/products/download-template', [ProductManagementController::class, 'downloadTemplate']);
    Route::post('/products/import', [ProductManagementController::class, 'importProducts']);
    Route::get('/products/export', [ProductManagementController::class, 'exportProducts']);
    Route::get('/products/restaurants', [ProductManagementController::class, 'getRestaurants']);
    Route::get('/products/categories', [ProductManagementController::class, 'getCategories']);
    Route::get('/products', [ProductManagementController::class, 'index']);
    Route::post('/products', [ProductManagementController::class, 'store']);
    Route::get('/products/{product}', [ProductManagementController::class, 'show']);
    Route::put('/products/{product}', [ProductManagementController::class, 'update']);
    Route::delete('/products/{product}', [ProductManagementController::class, 'destroy']);
    Route::post('/products/{product}/verify', [ProductManagementController::class, 'verify']);
    Route::post('/products/{product}/reject', [ProductManagementController::class, 'reject']);
    Route::post('/products/{product}/toggle-availability', [ProductManagementController::class, 'toggleAvailability']);
    Route::post('/products/{product}/toggle-featured', [ProductManagementController::class, 'toggleFeatured']);
    
    // Global Products
    Route::get('/global-products', [GlobalProductController::class, 'index']);
    Route::post('/global-products', [GlobalProductController::class, 'store']);
    Route::put('/global-products/{id}', [GlobalProductController::class, 'update']);
    Route::delete('/global-products/{id}', [GlobalProductController::class, 'destroy']);
    Route::post('/global-products/{id}/toggle-active', [GlobalProductController::class, 'toggleActive']);
    Route::post('/global-products/{id}/assign', [GlobalProductController::class, 'assignToRestaurant']);
    
    // Category Management
    Route::get('/categories', [CategoryManagementController::class, 'index']);
    Route::post('/categories', [CategoryManagementController::class, 'store']);
    Route::put('/categories/{category}', [CategoryManagementController::class, 'update']);
    Route::delete('/categories/{category}', [CategoryManagementController::class, 'destroy']);
    Route::get('/categories/{category}/variations', [CategoryManagementController::class, 'getVariations']);
    Route::post('/categories/{category}/variations', [CategoryManagementController::class, 'addVariation']);
    Route::delete('/category-variations/{id}', [CategoryManagementController::class, 'deleteVariation']);
    Route::get('/categories/{category}/addons', [CategoryManagementController::class, 'getAddons']);
    Route::post('/categories/{category}/addons', [CategoryManagementController::class, 'addAddon']);
    Route::delete('/category-addons/{id}', [CategoryManagementController::class, 'deleteAddon']);
    
    // Restaurant Promotions
    Route::get('/restaurants/{restaurant}/products', [App\Http\Controllers\API\Admin\RestaurantPromotionController::class, 'getRestaurantProducts']);
    Route::post('/restaurants/{restaurant}/products/{product}', [App\Http\Controllers\API\Admin\RestaurantPromotionController::class, 'addProduct']);
    Route::post('/restaurants/{restaurant}/products/{product}/promotion', [App\Http\Controllers\API\Admin\RestaurantPromotionController::class, 'updatePromotion']);
    
    // Order Management
    Route::get('/orders', [OrderManagementController::class, 'index']);
    Route::get('/orders/dashboard-stats', [OrderManagementController::class, 'getDashboardStats']);
    Route::get('/orders/restaurants', [OrderManagementController::class, 'getRestaurants']);
    Route::get('/orders/delivery-boys', [OrderManagementController::class, 'getDeliveryBoys']);
    Route::get('/orders/export', [OrderManagementController::class, 'exportOrders']);
    Route::get('/orders/{order}', [OrderManagementController::class, 'show']);
    Route::put('/orders/{order}/status', [OrderManagementController::class, 'updateStatus']);
    Route::post('/orders/{order}/assign-delivery-boy', [OrderManagementController::class, 'assignDeliveryBoy']);
    Route::post('/orders/{order}/cancel', [OrderManagementController::class, 'cancelOrder']);
    Route::post('/orders/bulk-update-status', [OrderManagementController::class, 'bulkUpdateStatus']);
    Route::get('/orders/analytics', [OrderManagementController::class, 'getAnalytics']);
    
    // Restaurant Orders
    Route::get('/restaurants/{restaurant}/orders', [OrderManagementController::class, 'getRestaurantOrders']);
    
    // User Management
    Route::get('/users/dashboard-stats', [UserManagementController::class, 'getDashboardStats']);
    Route::get('/users/export', [UserManagementController::class, 'exportUsers']);
    Route::get('/users', [UserManagementController::class, 'index']);
    Route::post('/users', [UserManagementController::class, 'store']);
    Route::get('/users/{user}', [UserManagementController::class, 'show']);
    Route::put('/users/{user}', [UserManagementController::class, 'update']);
    Route::delete('/users/{user}', [UserManagementController::class, 'destroy']);
    Route::post('/users/{user}/block', [UserManagementController::class, 'block']);
    Route::post('/users/{user}/unblock', [UserManagementController::class, 'unblock']);
    Route::post('/users/{user}/reset-password', [UserManagementController::class, 'resetPassword']);
    Route::post('/users/{user}/assign-permissions', [UserManagementController::class, 'assignPermissions']);
    Route::get('/roles', [UserManagementController::class, 'getRoles']);
    Route::get('/permissions', [UserManagementController::class, 'getPermissions']);
    
    // Delivery Boy Management
    Route::get('/delivery-boys/dashboard-stats', [AdminDeliveryBoyController::class, 'getDashboardStats']);
    Route::get('/delivery-boys/export', [AdminDeliveryBoyController::class, 'exportDeliveryBoys']);
    Route::get('/delivery-boys', [AdminDeliveryBoyController::class, 'index']);
    Route::get('/delivery-boys/{deliveryBoy}', [AdminDeliveryBoyController::class, 'show']);
    Route::post('/delivery-boys', [AdminDeliveryBoyController::class, 'store']);
    Route::put('/delivery-boys/{deliveryBoy}', [AdminDeliveryBoyController::class, 'update']);
    Route::delete('/delivery-boys/{deliveryBoy}', [AdminDeliveryBoyController::class, 'destroy']);
    Route::post('/delivery-boys/{deliveryBoy}/block', [AdminDeliveryBoyController::class, 'block']);
    Route::post('/delivery-boys/{deliveryBoy}/verify-documents', [AdminDeliveryBoyController::class, 'verifyDocuments']);
    Route::post('/delivery-boys/{deliveryBoy}/vehicles', [AdminDeliveryBoyController::class, 'addVehicle']);
    Route::put('/delivery-boys/{deliveryBoy}/vehicles/{vehicle}', [AdminDeliveryBoyController::class, 'updateVehicle']);
    Route::delete('/delivery-boys/{deliveryBoy}/vehicles/{vehicle}', [AdminDeliveryBoyController::class, 'deleteVehicle']);
    Route::post('/delivery-boys/{deliveryBoy}/documents', [AdminDeliveryBoyController::class, 'uploadDocument']);
    Route::delete('/delivery-boys/{deliveryBoy}/documents/{document}', [AdminDeliveryBoyController::class, 'deleteDocument']);
    
    // Delivery Boy Commission Management (Super Admin Only)
    Route::middleware('role:super-admin')->group(function () {
        Route::get('/delivery-boys/commissions', [App\Http\Controllers\API\SuperAdmin\DeliveryBoyCommissionController::class, 'index']);
        Route::put('/delivery-boys/{id}/commission', [App\Http\Controllers\API\SuperAdmin\DeliveryBoyCommissionController::class, 'updateCommission']);
        Route::get('/delivery-boys/{id}/earnings', [App\Http\Controllers\API\SuperAdmin\DeliveryBoyCommissionController::class, 'earnings']);
        Route::get('/delivery-boys/earnings/all', [App\Http\Controllers\API\SuperAdmin\DeliveryBoyCommissionController::class, 'allEarnings']);
        Route::put('/delivery-boys/earnings/{id}/status', [App\Http\Controllers\API\SuperAdmin\DeliveryBoyCommissionController::class, 'updateEarningStatus']);
    });
});

