<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Cart;
use App\Models\Product;
use App\Models\Restaurant;
use Illuminate\Foundation\Testing\RefreshDatabase;

class OrderTest extends TestCase
{
    use RefreshDatabase;

    public function test_user_can_create_order()
    {
        $user = User::factory()->create();
        $restaurant = Restaurant::factory()->create();
        $product = Product::factory()->create(['restaurant_id' => $restaurant->id]);
        
        Cart::create([
            'user_id' => $user->id,
            'restaurant_id' => $restaurant->id,
            'product_id' => $product->id,
            'quantity' => 2,
            'unit_price' => 1000,
            'total_price' => 2000,
        ]);

        $response = $this->actingAs($user)->postJson('/api/orders', [
            'restaurant_id' => $restaurant->id,
            'delivery_address' => 'Test Address',
            'delivery_latitude' => 6.9271,
            'delivery_longitude' => 79.8612,
            'delivery_phone' => '0771234567',
            'payment_method' => 'cash',
        ]);

        $response->assertStatus(201);
        $this->assertDatabaseHas('orders', ['user_id' => $user->id]);
    }
}
